/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.config;

import java.util.concurrent.Executor;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.connection.AbstractServerConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpConnectionInterceptorFactoryChain;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.connection.TcpMessageMapper;
import org.springframework.integration.ip.tcp.connection.TcpNetClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpNetServerConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpNioClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpNioServerConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpSender;
import org.springframework.integration.ip.tcp.serializer.ByteArrayCrLfSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpConnectionFactoryFactoryBean
extends AbstractFactoryBean<AbstractConnectionFactory>
implements SmartLifecycle {
    private AbstractConnectionFactory connectionFactory;
    private String type;
    protected String host;
    protected int port;
    protected TcpListener listener;
    protected TcpSender sender;
    protected int soTimeout;
    private int soSendBufferSize;
    private int soReceiveBufferSize;
    private boolean soTcpNoDelay;
    private int soLinger = -1;
    private boolean soKeepAlive;
    private int soTrafficClass = -1;
    private Executor taskExecutor;
    protected Deserializer<?> deserializer = new ByteArrayCrLfSerializer();
    protected Serializer<?> serializer = new ByteArrayCrLfSerializer();
    protected TcpMessageMapper mapper = new TcpMessageMapper();
    protected boolean singleUse;
    protected int poolSize = 5;
    protected volatile boolean active;
    protected TcpConnectionInterceptorFactoryChain interceptorFactoryChain;
    private boolean lookupHost = true;
    private String localAddress;
    private boolean usingNio;
    private boolean usingDirectBuffers;

    public Class<?> getObjectType() {
        return this.connectionFactory != null ? this.connectionFactory.getClass() : AbstractConnectionFactory.class;
    }

    protected AbstractConnectionFactory createInstance() throws Exception {
        if (this.usingNio) {
            if ("server".equals(this.type)) {
                TcpNioServerConnectionFactory connectionFactory = new TcpNioServerConnectionFactory(this.port);
                this.setCommonAttributes(connectionFactory);
                this.setServerAttributes(connectionFactory);
                connectionFactory.setUsingDirectBuffers(this.usingDirectBuffers);
                this.connectionFactory = connectionFactory;
            } else {
                TcpNioClientConnectionFactory connectionFactory = new TcpNioClientConnectionFactory(this.host, this.port);
                this.setCommonAttributes(connectionFactory);
                connectionFactory.setUsingDirectBuffers(this.usingDirectBuffers);
                this.connectionFactory = connectionFactory;
            }
        } else if ("server".equals(this.type)) {
            TcpNetServerConnectionFactory connectionFactory = new TcpNetServerConnectionFactory(this.port);
            this.setCommonAttributes(connectionFactory);
            this.setServerAttributes(connectionFactory);
            this.connectionFactory = connectionFactory;
        } else {
            TcpNetClientConnectionFactory connectionFactory = new TcpNetClientConnectionFactory(this.host, this.port);
            this.setCommonAttributes(connectionFactory);
            this.connectionFactory = connectionFactory;
        }
        return this.connectionFactory;
    }

    private void setCommonAttributes(AbstractConnectionFactory factory) {
        factory.setDeserializer(this.deserializer);
        factory.setInterceptorFactoryChain(this.interceptorFactoryChain);
        factory.setLookupHost(this.lookupHost);
        factory.setMapper(this.mapper);
        factory.setPoolSize(this.poolSize);
        factory.setSerializer(this.serializer);
        factory.setSingleUse(this.singleUse);
        factory.setSoKeepAlive(this.soKeepAlive);
        factory.setSoLinger(this.soLinger);
        factory.setSoReceiveBufferSize(this.soReceiveBufferSize);
        factory.setSoSendBufferSize(this.soSendBufferSize);
        factory.setSoTcpNoDelay(this.soTcpNoDelay);
        factory.setSoTimeout(this.soTimeout);
        factory.setSoTrafficClass(this.soTrafficClass);
        factory.setTaskExecutor(this.taskExecutor);
    }

    private void setServerAttributes(AbstractServerConnectionFactory factory) {
        factory.setLocalAddress(this.localAddress);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setSoReceiveBufferSize(int soReceiveBufferSize) {
        this.soReceiveBufferSize = soReceiveBufferSize;
    }

    public void setSoSendBufferSize(int soSendBufferSize) {
        this.soSendBufferSize = soSendBufferSize;
    }

    public void setSoTcpNoDelay(boolean soTcpNoDelay) {
        this.soTcpNoDelay = soTcpNoDelay;
    }

    public void setSoLinger(int soLinger) {
        this.soLinger = soLinger;
    }

    public void setSoKeepAlive(boolean soKeepAlive) {
        this.soKeepAlive = soKeepAlive;
    }

    public void setSoTrafficClass(int soTrafficClass) {
        this.soTrafficClass = soTrafficClass;
    }

    public void setUsingNio(boolean usingNio) {
        this.usingNio = usingNio;
    }

    public void setUsingDirectBuffers(boolean usingDirectBuffers) {
        this.usingDirectBuffers = usingDirectBuffers;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setDeserializer(Deserializer<?> deserializer) {
        this.deserializer = deserializer;
    }

    public void setSerializer(Serializer<?> serializer) {
        this.serializer = serializer;
    }

    public void setMapper(TcpMessageMapper mapper) {
        this.mapper = mapper;
    }

    public void setSingleUse(boolean singleUse) {
        this.singleUse = singleUse;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setInterceptorFactoryChain(TcpConnectionInterceptorFactoryChain interceptorFactoryChain) {
        this.interceptorFactoryChain = interceptorFactoryChain;
    }

    public void setLookupHost(boolean lookupHost) {
        this.lookupHost = lookupHost;
    }

    public void start() {
        this.connectionFactory.start();
    }

    public void stop() {
        this.connectionFactory.stop();
    }

    public int getPhase() {
        return this.connectionFactory.getPhase();
    }

    public boolean isAutoStartup() {
        return this.connectionFactory.isAutoStartup();
    }

    public void stop(Runnable callback) {
        this.connectionFactory.stop(callback);
    }

    public boolean isRunning() {
        return this.connectionFactory.isRunning();
    }
}

