/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.Message;
import org.springframework.integration.MessageDeliveryException;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.MessageRejectedException;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.ip.tcp.connection.AbstractClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.connection.ConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpSender;
import org.springframework.integration.mapping.MessageMappingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpSendingMessageHandler
extends AbstractMessageHandler
implements TcpSender {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected TcpConnection connection;
    protected ConnectionFactory clientConnectionFactory;
    protected ConnectionFactory serverConnectionFactory;
    protected Map<String, TcpConnection> connections = new ConcurrentHashMap<String, TcpConnection>();

    protected synchronized TcpConnection getConnection() {
        try {
            this.connection = this.clientConnectionFactory.getConnection();
        }
        catch (Exception e) {
            this.logger.error((Object)"Error creating SocketWriter", (Throwable)e);
        }
        return this.connection;
    }

    protected void close() {
        this.connection.close();
        this.connection = null;
    }

    public void handleMessageInternal(Message<?> message) throws MessageRejectedException, MessageHandlingException, MessageDeliveryException {
        if (this.serverConnectionFactory != null) {
            Object connectionId = message.getHeaders().get((Object)"ip_connection_id");
            TcpConnection connection = this.connections.get(connectionId);
            if (connection != null) {
                try {
                    connection.send(message);
                }
                catch (Exception e) {
                    this.logger.error((Object)"Error sending message", (Throwable)e);
                    connection.close();
                }
            } else {
                this.logger.error((Object)("Unable to find incoming socket for " + message));
            }
            return;
        }
        try {
            this.doWrite(message);
        }
        catch (MessageMappingException e) {
            if (e.getCause() instanceof IOException) {
                this.logger.debug((Object)"Fail on first write attempt", (Throwable)e);
                this.doWrite(message);
            }
            throw e;
        }
    }

    protected void doWrite(Message<?> message) {
        try {
            TcpConnection connection = this.getConnection();
            if (connection == null) {
                throw new MessageMappingException(message, "Failed to create connection");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Got Connection " + connection.getConnectionId()));
            }
            connection.send(message);
        }
        catch (Exception e) {
            String connectionId = null;
            if (this.connection != null) {
                connectionId = this.connection.getConnectionId();
            }
            this.connection = null;
            if (e instanceof MessageMappingException) {
                throw (MessageMappingException)((Object)e);
            }
            throw new MessageMappingException(message, "Failed to map message using " + connectionId, (Throwable)e);
        }
    }

    public void setConnectionFactory(AbstractConnectionFactory connectionFactory) {
        if (connectionFactory instanceof AbstractClientConnectionFactory) {
            this.clientConnectionFactory = connectionFactory;
        } else {
            this.serverConnectionFactory = connectionFactory;
            connectionFactory.registerSender(this);
        }
    }

    @Override
    public void addNewConnection(TcpConnection connection) {
        this.connections.put(connection.getConnectionId(), connection);
    }

    @Override
    public void removeDeadConnection(TcpConnection connection) {
        this.connections.remove(connection.getConnectionId());
    }

    public String getComponentType() {
        return "ip:tcp-outbound-channel-adapter";
    }
}

