/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.net.Socket;
import java.net.SocketException;
import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpConnection;

public abstract class AbstractServerConnectionFactory
extends AbstractConnectionFactory {
    protected boolean listening;
    protected String localAddress;

    public AbstractServerConnectionFactory(int port) {
        this.port = port;
    }

    public TcpConnection getConnection() throws Exception {
        throw new UnsupportedOperationException("Getting a connection from a server factory is not supported");
    }

    public boolean isListening() {
        return this.listening;
    }

    protected void initializeConnection(TcpConnection connection, Socket socket) {
        if (this.listener != null) {
            connection.registerListener(this.listener);
        }
        connection.registerSender(this.sender);
        connection.setMapper(this.mapper);
        connection.setDeserializer(this.deserializer);
        connection.setSerializer(this.serializer);
        connection.setSingleUse(this.singleUse);
        if (this.singleUse && this.soTimeout <= 0 && this.listener != null) {
            try {
                socket.setSoTimeout(10000);
            }
            catch (SocketException e) {
                this.logger.error((Object)"Error setting default reply timeout", (Throwable)e);
            }
        }
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }
}

