/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.net.InetSocketAddress;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.integration.ip.tcp.connection.AbstractClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpNioConnection;

public class TcpNioClientConnectionFactory
extends AbstractClientConnectionFactory {
    protected boolean usingDirectBuffers;
    private Selector selector;
    protected Map<SocketChannel, TcpNioConnection> connections = new ConcurrentHashMap<SocketChannel, TcpNioConnection>();
    protected BlockingQueue<SocketChannel> newChannels = new LinkedBlockingQueue<SocketChannel>();

    public TcpNioClientConnectionFactory(String host, int port) {
        super(host, port);
    }

    public TcpConnection getConnection() throws Exception {
        int n = 0;
        while (this.selector == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (n++ <= 600) continue;
            throw new Exception("Factory failed to start");
        }
        if (this.theConnection != null && this.theConnection.isOpen()) {
            return this.theConnection;
        }
        this.logger.debug((Object)("Opening new socket channel connection to " + this.host + ":" + this.port));
        SocketChannel socketChannel = SocketChannel.open(new InetSocketAddress(this.host, this.port));
        this.setSocketAttributes(socketChannel.socket());
        TcpNioConnection connection = new TcpNioConnection(socketChannel, false, this.isLookupHost());
        connection.setUsingDirectBuffers(this.usingDirectBuffers);
        connection.setTaskExecutor(this.getTaskExecutor());
        TcpConnection wrappedConnection = this.wrapConnection(connection);
        this.initializeConnection(wrappedConnection, socketChannel.socket());
        socketChannel.configureBlocking(false);
        if (this.soTimeout > 0) {
            connection.setLastRead(System.currentTimeMillis());
        }
        this.connections.put(socketChannel, connection);
        this.newChannels.add(socketChannel);
        this.selector.wakeup();
        if (!this.singleUse) {
            this.theConnection = wrappedConnection;
        }
        return wrappedConnection;
    }

    public void setUsingDirectBuffers(boolean usingDirectBuffers) {
        this.usingDirectBuffers = usingDirectBuffers;
    }

    public void close() {
        if (this.selector != null) {
            this.selector.wakeup();
        }
    }

    public void run() {
        this.logger.debug((Object)("Read selector running for connections to " + this.host + ":" + this.port));
        try {
            this.selector = Selector.open();
            while (this.active) {
                SocketChannel newChannel;
                int selectionCount = this.selector.select(this.soTimeout);
                while ((newChannel = (SocketChannel)this.newChannels.poll()) != null) {
                    newChannel.register(this.selector, 1, this.connections.get(newChannel));
                }
                this.processNioSelections(selectionCount, this.selector, null, this.connections);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception in read selector thread", (Throwable)e);
            this.active = false;
        }
        this.logger.debug((Object)("Read selector exiting for connections to " + this.host + ":" + this.port));
    }

    public boolean isRunning() {
        return this.active;
    }
}

