/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.udp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import org.springframework.integration.MessagingException;
import org.springframework.integration.ip.udp.UnicastReceivingChannelAdapter;

public class MulticastReceivingChannelAdapter
extends UnicastReceivingChannelAdapter {
    protected String group;

    public MulticastReceivingChannelAdapter(String group, int port) {
        super(port);
        this.group = group;
    }

    public MulticastReceivingChannelAdapter(String group, int port, boolean lengthCheck) {
        super(port, lengthCheck);
        this.group = group;
    }

    protected synchronized DatagramSocket getSocket() {
        if (this.socket == null) {
            try {
                MulticastSocket socket = new MulticastSocket(this.port);
                if (this.localAddress != null) {
                    InetAddress whichNic = InetAddress.getByName(this.localAddress);
                    socket.setInterface(whichNic);
                }
                socket.setSoTimeout(this.soTimeout);
                if (this.soReceiveBufferSize > 0) {
                    socket.setReceiveBufferSize(this.soReceiveBufferSize);
                }
                socket.joinGroup(InetAddress.getByName(this.group));
                this.socket = socket;
            }
            catch (IOException e) {
                throw new MessagingException("failed to create DatagramSocket", (Throwable)e);
            }
        }
        return this.socket;
    }
}

