/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.ip.config.IpAdapterParserUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class UdpOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    private static final String BASE_PACKAGE = "org.springframework.integration.ip.udp";

    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.parseUdp(element, parserContext);
        IpAdapterParserUtils.addCommonSocketOptions(builder, element);
        return builder.getBeanDefinition();
    }

    private BeanDefinitionBuilder parseUdp(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder;
        String multicast = IpAdapterParserUtils.getMulticast(element);
        if (multicast.equals("true")) {
            builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.ip.udp.MulticastSendingMessageHandler");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"min-acks-for-success", (String)"minAcksForSuccess");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"time-to-live", (String)"timeToLive");
        } else {
            builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.ip.udp.UnicastSendingMessageHandler");
        }
        IpAdapterParserUtils.addHostAndPortToConstructor(element, builder, parserContext);
        IpAdapterParserUtils.addConstuctorValueIfAttributeDefined(builder, element, "check-length", true);
        IpAdapterParserUtils.addConstuctorValueIfAttributeDefined(builder, element, "acknowledge", true);
        IpAdapterParserUtils.addConstuctorValueIfAttributeDefined(builder, element, "ack-host", false);
        IpAdapterParserUtils.addConstuctorValueIfAttributeDefined(builder, element, "ack-port", false);
        IpAdapterParserUtils.addConstuctorValueIfAttributeDefined(builder, element, "ack-timeout", false);
        String ack = element.getAttribute("acknowledge");
        if (!(!ack.equals("true") || StringUtils.hasText((String)element.getAttribute("ack-host")) && StringUtils.hasText((String)element.getAttribute("ack-port")) && StringUtils.hasText((String)element.getAttribute("ack-timeout")))) {
            parserContext.getReaderContext().error("When acknowledge is true, ack-host, ack-port, and ack-timeout must be supplied", (Object)element);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"receive-buffer-size");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"task-executor");
        return builder;
    }
}

