/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.net.Socket;
import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.connection.TcpSender;

public abstract class AbstractClientConnectionFactory
extends AbstractConnectionFactory {
    private TcpConnection theConnection;

    public AbstractClientConnectionFactory(String host, int port) {
        super(host, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TcpConnection getConnection() throws Exception {
        this.checkActive();
        if (this.isSingleUse()) {
            return this.obtainConnection();
        }
        AbstractClientConnectionFactory abstractClientConnectionFactory = this;
        synchronized (abstractClientConnectionFactory) {
            TcpConnection connection = this.obtainConnection();
            this.setTheConnection(connection);
            return connection;
        }
    }

    protected abstract TcpConnection obtainConnection() throws Exception;

    protected void initializeConnection(TcpConnection connection, Socket socket) {
        TcpSender sender;
        TcpListener listener = this.getListener();
        if (listener != null) {
            connection.registerListener(listener);
        }
        if ((sender = this.getSender()) != null) {
            connection.registerSender(sender);
        }
        connection.setMapper(this.getMapper());
        connection.setDeserializer(this.getDeserializer());
        connection.setSerializer(this.getSerializer());
        connection.setSingleUse(this.isSingleUse());
    }

    protected void setTheConnection(TcpConnection theConnection) {
        this.theConnection = theConnection;
    }

    protected TcpConnection getTheConnection() {
        return this.theConnection;
    }
}

