/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection.support;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.integration.ip.tcp.connection.support.TcpSSLContextSupport;
import org.springframework.util.Assert;

public class DefaultTcpSSLContextSupport
implements TcpSSLContextSupport {
    private final Resource keyStore;
    private final Resource trustStore;
    private final char[] keyStorePassword;
    private final char[] trustStorePassword;
    private volatile String protocol = "TLS";

    public DefaultTcpSSLContextSupport(String keyStore, String trustStore, String keyStorePassword, String trustStorePassword) {
        Assert.notNull((Object)keyStore, (String)"keyStore cannot be null");
        Assert.notNull((Object)trustStore, (String)"trustStore cannot be null");
        Assert.notNull((Object)keyStorePassword, (String)"keyStorePassword cannot be null");
        Assert.notNull((Object)trustStorePassword, (String)"trustStorePassword cannot be null");
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        this.keyStore = resolver.getResource(keyStore);
        this.trustStore = resolver.getResource(trustStore);
        this.keyStorePassword = keyStorePassword.toCharArray();
        this.trustStorePassword = trustStorePassword.toCharArray();
    }

    public SSLContext getSSLContext() throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("JKS");
        KeyStore ts = KeyStore.getInstance("JKS");
        ks.load(this.keyStore.getInputStream(), this.keyStorePassword);
        ts.load(this.trustStore.getInputStream(), this.trustStorePassword);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(ks, this.keyStorePassword);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(ts);
        SSLContext sslContext = SSLContext.getInstance(this.protocol);
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        return sslContext;
    }

    public void setProtocol(String protocol) {
        Assert.notNull((Object)protocol, (String)"protocol must not be null");
        this.protocol = protocol;
    }
}

