/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.Message;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpConnectionInterceptor;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.connection.TcpMessageMapper;
import org.springframework.integration.ip.tcp.connection.TcpSender;
import org.springframework.integration.ip.tcp.serializer.AbstractByteArraySerializer;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTcpConnection
implements TcpConnection {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile Deserializer deserializer;
    private volatile Serializer serializer;
    private volatile TcpMessageMapper mapper;
    private volatile TcpListener listener;
    private volatile TcpListener actualListener;
    private volatile TcpSender sender;
    private volatile boolean singleUse;
    private final boolean server;
    private volatile String connectionId;
    private final AtomicLong sequence = new AtomicLong();
    private volatile int soLinger = -1;
    private volatile String hostName = "unknown";
    private volatile String hostAddress = "unknown";
    private volatile boolean noReadErrorOnClose;

    public AbstractTcpConnection(Socket socket, boolean server, boolean lookupHost) {
        this.server = server;
        InetAddress inetAddress = socket.getInetAddress();
        if (inetAddress != null) {
            this.hostAddress = inetAddress.getHostAddress();
            this.hostName = lookupHost ? inetAddress.getHostName() : this.hostAddress;
        }
        int port = socket.getPort();
        this.connectionId = this.hostName + ":" + port + ":" + UUID.randomUUID().toString();
        try {
            this.soLinger = socket.getSoLinger();
        }
        catch (SocketException e) {
            // empty catch block
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("New connection " + this.getConnectionId()));
        }
    }

    public void afterSend(Message<?> message) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Message sent " + message));
        }
        if (this.singleUse && (this.isServer() || this.actualListener == null) && this.soLinger != 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Closing single-use connection" + this.getConnectionId()));
            }
            this.closeConnection(false);
        }
    }

    @Override
    public void close() {
        if (this.sender != null) {
            this.sender.removeDeadConnection(this);
        }
    }

    protected void closeConnection(boolean isException) {
        if (!(this.listener instanceof TcpConnectionInterceptor)) {
            this.close();
            return;
        }
        TcpConnectionInterceptor outerInterceptor = (TcpConnectionInterceptor)this.listener;
        while (outerInterceptor.getListener() instanceof TcpConnectionInterceptor) {
            outerInterceptor = (TcpConnectionInterceptor)outerInterceptor.getListener();
        }
        outerInterceptor.close();
        if (isException) {
            this.close();
        }
    }

    public TcpMessageMapper getMapper() {
        return this.mapper;
    }

    @Override
    public void setMapper(TcpMessageMapper mapper) {
        Assert.notNull((Object)mapper, (String)(this.getClass().getName() + " Mapper may not be null"));
        this.mapper = mapper;
        if (this.serializer != null && !(this.serializer instanceof AbstractByteArraySerializer)) {
            mapper.setStringToBytes(false);
        }
    }

    @Override
    public Deserializer<?> getDeserializer() {
        return this.deserializer;
    }

    @Override
    public void setDeserializer(Deserializer<?> deserializer) {
        this.deserializer = deserializer;
    }

    @Override
    public Serializer<?> getSerializer() {
        return this.serializer;
    }

    @Override
    public void setSerializer(Serializer<?> serializer) {
        this.serializer = serializer;
        if (!(serializer instanceof AbstractByteArraySerializer)) {
            this.mapper.setStringToBytes(false);
        }
    }

    @Override
    public void registerListener(TcpListener listener) {
        this.listener = listener;
        if (!(this.listener instanceof TcpConnectionInterceptor)) {
            this.actualListener = this.listener;
        } else {
            TcpConnectionInterceptor outerInterceptor = (TcpConnectionInterceptor)this.listener;
            while (outerInterceptor.getListener() instanceof TcpConnectionInterceptor) {
                outerInterceptor = (TcpConnectionInterceptor)outerInterceptor.getListener();
            }
            this.actualListener = outerInterceptor.getListener();
        }
    }

    @Override
    public void registerSender(TcpSender sender) {
        this.sender = sender;
        if (sender != null) {
            sender.addNewConnection(this);
        }
    }

    @Override
    public TcpListener getListener() {
        return this.listener;
    }

    public TcpSender getSender() {
        return this.sender;
    }

    @Override
    public void setSingleUse(boolean singleUse) {
        this.singleUse = singleUse;
    }

    @Override
    public boolean isSingleUse() {
        return this.singleUse;
    }

    @Override
    public boolean isServer() {
        return this.server;
    }

    @Override
    public long incrementAndGetConnectionSequence() {
        return this.sequence.incrementAndGet();
    }

    @Override
    public String getHostAddress() {
        return this.hostAddress;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public String getConnectionId() {
        return this.connectionId;
    }

    protected boolean isNoReadErrorOnClose() {
        return this.noReadErrorOnClose;
    }

    protected void setNoReadErrorOnClose(boolean noReadErrorOnClose) {
        this.noReadErrorOnClose = noReadErrorOnClose;
    }
}

