/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.util.concurrent.Executor;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.Message;
import org.springframework.integration.MessagingException;
import org.springframework.integration.ip.tcp.connection.AbstractClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.AbstractTcpConnection;
import org.springframework.integration.ip.tcp.connection.AbstractTcpConnectionInterceptor;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpConnectionInterceptorFactoryChain;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.connection.TcpMessageMapper;
import org.springframework.integration.ip.tcp.connection.TcpSender;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.util.SimplePool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingClientConnectionFactory
extends AbstractClientConnectionFactory {
    private final AbstractClientConnectionFactory targetConnectionFactory;
    private final SimplePool<TcpConnection> pool;
    private volatile TcpListener listener;

    public CachingClientConnectionFactory(AbstractClientConnectionFactory target, int poolSize) {
        super("", 0);
        target.setSingleUse(true);
        this.targetConnectionFactory = target;
        this.pool = new SimplePool(poolSize, (SimplePool.PoolItemCallback)new SimplePool.PoolItemCallback<TcpConnection>(){

            public TcpConnection createForPool() {
                try {
                    return CachingClientConnectionFactory.this.targetConnectionFactory.getConnection();
                }
                catch (Exception e) {
                    throw new MessagingException("Failed to obtain connection", (Throwable)e);
                }
            }

            public boolean isStale(TcpConnection connection) {
                return !connection.isOpen();
            }

            public void removedFromPool(TcpConnection connection) {
                connection.close();
            }
        });
    }

    public void setConnectionWaitTimeout(int connectionWaitTimeout) {
        this.pool.setWaitTimeout((long)connectionWaitTimeout);
    }

    @Override
    public synchronized void setPoolSize(int poolSize) {
        this.pool.setPoolSize(poolSize);
    }

    @Override
    public int getPoolSize() {
        return this.pool.getPoolSize();
    }

    public int getIdleCount() {
        return this.pool.getIdleCount();
    }

    public int getActiveCount() {
        return this.pool.getActiveCount();
    }

    public int getAllocatedCount() {
        return this.pool.getAllocatedCount();
    }

    @Override
    public TcpConnection obtainConnection() throws Exception {
        return new CachedConnection((TcpConnection)this.pool.getItem());
    }

    @Override
    public boolean isRunning() {
        return this.targetConnectionFactory.isRunning();
    }

    @Override
    public void close() {
        this.targetConnectionFactory.close();
    }

    public int hashCode() {
        return this.targetConnectionFactory.hashCode();
    }

    public void setComponentName(String componentName) {
        this.targetConnectionFactory.setComponentName(componentName);
    }

    public String getComponentType() {
        return this.targetConnectionFactory.getComponentType();
    }

    public boolean equals(Object obj) {
        return this.targetConnectionFactory.equals(obj);
    }

    @Override
    public int getSoTimeout() {
        return this.targetConnectionFactory.getSoTimeout();
    }

    @Override
    public void setSoTimeout(int soTimeout) {
        this.targetConnectionFactory.setSoTimeout(soTimeout);
    }

    @Override
    public int getSoReceiveBufferSize() {
        return this.targetConnectionFactory.getSoReceiveBufferSize();
    }

    @Override
    public void setSoReceiveBufferSize(int soReceiveBufferSize) {
        this.targetConnectionFactory.setSoReceiveBufferSize(soReceiveBufferSize);
    }

    @Override
    public int getSoSendBufferSize() {
        return this.targetConnectionFactory.getSoSendBufferSize();
    }

    @Override
    public void setSoSendBufferSize(int soSendBufferSize) {
        this.targetConnectionFactory.setSoSendBufferSize(soSendBufferSize);
    }

    @Override
    public boolean isSoTcpNoDelay() {
        return this.targetConnectionFactory.isSoTcpNoDelay();
    }

    @Override
    public void setSoTcpNoDelay(boolean soTcpNoDelay) {
        this.targetConnectionFactory.setSoTcpNoDelay(soTcpNoDelay);
    }

    @Override
    public int getSoLinger() {
        return this.targetConnectionFactory.getSoLinger();
    }

    @Override
    public void setSoLinger(int soLinger) {
        this.targetConnectionFactory.setSoLinger(soLinger);
    }

    @Override
    public boolean isSoKeepAlive() {
        return this.targetConnectionFactory.isSoKeepAlive();
    }

    @Override
    public void setSoKeepAlive(boolean soKeepAlive) {
        this.targetConnectionFactory.setSoKeepAlive(soKeepAlive);
    }

    @Override
    public int getSoTrafficClass() {
        return this.targetConnectionFactory.getSoTrafficClass();
    }

    @Override
    public void setSoTrafficClass(int soTrafficClass) {
        this.targetConnectionFactory.setSoTrafficClass(soTrafficClass);
    }

    @Override
    public String getHost() {
        return this.targetConnectionFactory.getHost();
    }

    @Override
    public int getPort() {
        return this.targetConnectionFactory.getPort();
    }

    @Override
    public TcpListener getListener() {
        return this.targetConnectionFactory.getListener();
    }

    @Override
    public TcpSender getSender() {
        return this.targetConnectionFactory.getSender();
    }

    @Override
    public Serializer<?> getSerializer() {
        return this.targetConnectionFactory.getSerializer();
    }

    @Override
    public Deserializer<?> getDeserializer() {
        return this.targetConnectionFactory.getDeserializer();
    }

    @Override
    public TcpMessageMapper getMapper() {
        return this.targetConnectionFactory.getMapper();
    }

    @Override
    public void registerListener(TcpListener listener) {
        this.listener = listener;
        this.targetConnectionFactory.registerListener(listener);
    }

    @Override
    public void registerSender(TcpSender sender) {
        this.targetConnectionFactory.registerSender(sender);
    }

    @Override
    public void setTaskExecutor(Executor taskExecutor) {
        this.targetConnectionFactory.setTaskExecutor(taskExecutor);
    }

    @Override
    public void setDeserializer(Deserializer<?> deserializer) {
        this.targetConnectionFactory.setDeserializer(deserializer);
    }

    @Override
    public void setSerializer(Serializer<?> serializer) {
        this.targetConnectionFactory.setSerializer(serializer);
    }

    @Override
    public void setMapper(TcpMessageMapper mapper) {
        this.targetConnectionFactory.setMapper(mapper);
    }

    @Override
    public boolean isSingleUse() {
        return this.targetConnectionFactory.isSingleUse();
    }

    @Override
    public void setSingleUse(boolean singleUse) {
        this.targetConnectionFactory.setSingleUse(singleUse);
    }

    @Override
    public void setInterceptorFactoryChain(TcpConnectionInterceptorFactoryChain interceptorFactoryChain) {
        this.targetConnectionFactory.setInterceptorFactoryChain(interceptorFactoryChain);
    }

    @Override
    public void setLookupHost(boolean lookupHost) {
        this.targetConnectionFactory.setLookupHost(lookupHost);
    }

    @Override
    public boolean isLookupHost() {
        return this.targetConnectionFactory.isLookupHost();
    }

    @Override
    public void forceClose(TcpConnection connection) {
        if (connection instanceof CachedConnection) {
            ((CachedConnection)connection).physicallyClose();
        }
        super.forceClose(connection);
    }

    @Override
    public void start() {
        this.setActive(true);
        this.targetConnectionFactory.start();
        super.start();
    }

    @Override
    public synchronized void stop() {
        this.targetConnectionFactory.stop();
        this.pool.removeAllIdleItems();
    }

    @Override
    public int getPhase() {
        return this.targetConnectionFactory.getPhase();
    }

    @Override
    public boolean isAutoStartup() {
        return this.targetConnectionFactory.isAutoStartup();
    }

    @Override
    public void stop(Runnable callback) {
        this.targetConnectionFactory.stop(callback);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CachedConnection
    extends AbstractTcpConnectionInterceptor {
        private volatile boolean released;

        public CachedConnection(TcpConnection connection) {
            super.setTheConnection(connection);
            if (connection instanceof AbstractTcpConnection) {
                ((AbstractTcpConnection)connection).registerListener(this);
            }
        }

        @Override
        public synchronized void close() {
            if (this.released) {
                if (CachingClientConnectionFactory.this.logger.isDebugEnabled()) {
                    CachingClientConnectionFactory.this.logger.debug((Object)("Connection " + this.getConnectionId() + " has already been released"));
                }
            } else {
                if (!CachingClientConnectionFactory.this.isRunning()) {
                    if (CachingClientConnectionFactory.this.logger.isDebugEnabled()) {
                        CachingClientConnectionFactory.this.logger.debug((Object)("Factory not running - closing " + this.getConnectionId()));
                    }
                    super.close();
                }
                CachingClientConnectionFactory.this.pool.releaseItem((Object)this.getTheConnection());
                this.released = true;
            }
        }

        @Override
        public String getConnectionId() {
            return "Cached:" + super.getConnectionId();
        }

        public String toString() {
            return this.getConnectionId();
        }

        @Override
        public TcpListener getListener() {
            return CachingClientConnectionFactory.this.listener;
        }

        @Override
        public boolean onMessage(Message<?> message) {
            CachingClientConnectionFactory.this.listener.onMessage(MessageBuilder.fromMessage(message).setHeader("ip_connectionId", (Object)this.getConnectionId()).setHeader("ip_actualConnectionId", message.getHeaders().get((Object)"ip_connectionId")).build());
            this.close();
            return true;
        }

        private void physicallyClose() {
            this.getTheConnection().close();
        }
    }
}

