/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import org.springframework.integration.ip.tcp.connection.AbstractClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.DefaultTcpNetSocketFactorySupport;
import org.springframework.integration.ip.tcp.connection.TcpConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpNetConnection;
import org.springframework.integration.ip.tcp.connection.TcpSocketFactorySupport;
import org.springframework.util.Assert;

public class TcpNetClientConnectionFactory
extends AbstractClientConnectionFactory {
    private volatile TcpSocketFactorySupport tcpSocketFactorySupport = new DefaultTcpNetSocketFactorySupport();

    public TcpNetClientConnectionFactory(String host, int port) {
        super(host, port);
    }

    @Override
    protected TcpConnectionSupport buildNewConnection() throws IOException, SocketException, Exception {
        Socket socket = this.createSocket(this.getHost(), this.getPort());
        this.setSocketAttributes(socket);
        TcpConnectionSupport connection = new TcpNetConnection(socket, false, this.isLookupHost(), this.getApplicationEventPublisher(), this.getComponentName());
        connection = this.wrapConnection(connection);
        this.initializeConnection(connection, socket);
        this.getTaskExecutor().execute(connection);
        this.harvestClosedConnections();
        return connection;
    }

    @Override
    public void start() {
        this.setActive(true);
        super.start();
    }

    protected Socket createSocket(String host, int port) throws IOException {
        return this.tcpSocketFactorySupport.getSocketFactory().createSocket(host, port);
    }

    @Override
    public void close() {
    }

    protected TcpSocketFactorySupport getTcpSocketFactorySupport() {
        return this.tcpSocketFactorySupport;
    }

    public void setTcpSocketFactorySupport(TcpSocketFactorySupport tcpSocketFactorySupport) {
        Assert.notNull((Object)tcpSocketFactorySupport, (String)"TcpSocketFactorySupport may not be null");
        this.tcpSocketFactorySupport = tcpSocketFactorySupport;
    }
}

