/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.config;

import java.util.concurrent.Executor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.connection.AbstractServerConnectionFactory;
import org.springframework.integration.ip.tcp.connection.DefaultTcpNetSSLSocketFactorySupport;
import org.springframework.integration.ip.tcp.connection.DefaultTcpNetSocketFactorySupport;
import org.springframework.integration.ip.tcp.connection.DefaultTcpNioConnectionSupport;
import org.springframework.integration.ip.tcp.connection.DefaultTcpNioSSLConnectionSupport;
import org.springframework.integration.ip.tcp.connection.DefaultTcpSocketSupport;
import org.springframework.integration.ip.tcp.connection.TcpConnectionInterceptorFactoryChain;
import org.springframework.integration.ip.tcp.connection.TcpMessageMapper;
import org.springframework.integration.ip.tcp.connection.TcpNetClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpNetServerConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpNioClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpNioConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpNioServerConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpSSLContextSupport;
import org.springframework.integration.ip.tcp.connection.TcpSocketFactorySupport;
import org.springframework.integration.ip.tcp.connection.TcpSocketSupport;
import org.springframework.integration.ip.tcp.serializer.ByteArrayCrLfSerializer;
import org.springframework.util.Assert;

public class TcpConnectionFactoryFactoryBean
extends AbstractFactoryBean<AbstractConnectionFactory>
implements SmartLifecycle,
BeanNameAware,
BeanFactoryAware,
ApplicationEventPublisherAware {
    private volatile AbstractConnectionFactory connectionFactory;
    private volatile String type;
    private volatile String host;
    private volatile int port;
    private volatile int soTimeout;
    private volatile int soSendBufferSize;
    private volatile int soReceiveBufferSize;
    private volatile boolean soTcpNoDelay;
    private volatile int soLinger = -1;
    private volatile boolean soKeepAlive;
    private volatile int soTrafficClass = -1;
    private volatile Executor taskExecutor;
    private volatile Deserializer<?> deserializer = new ByteArrayCrLfSerializer();
    private volatile Serializer<?> serializer = new ByteArrayCrLfSerializer();
    private volatile TcpMessageMapper mapper = new TcpMessageMapper();
    private volatile boolean mapperSet;
    private volatile boolean singleUse;
    private volatile int backlog = 5;
    private volatile TcpConnectionInterceptorFactoryChain interceptorFactoryChain;
    private volatile boolean lookupHost = true;
    private volatile String localAddress;
    private volatile boolean usingNio;
    private volatile boolean usingDirectBuffers;
    private volatile String beanName;
    private volatile boolean applySequence;
    private volatile Long readDelay;
    private volatile TcpSSLContextSupport sslContextSupport;
    private volatile TcpSocketSupport socketSupport = new DefaultTcpSocketSupport();
    private volatile TcpNioConnectionSupport nioConnectionSupport;
    private volatile TcpSocketFactorySupport socketFactorySupport;
    private volatile ApplicationEventPublisher applicationEventPublisher;
    private volatile BeanFactory beanFactory;

    public final void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Class<?> getObjectType() {
        return this.connectionFactory != null ? this.connectionFactory.getClass() : AbstractConnectionFactory.class;
    }

    protected AbstractConnectionFactory createInstance() throws Exception {
        if (!this.mapperSet) {
            this.mapper.setBeanFactory(this.beanFactory);
        }
        if (this.usingNio) {
            if ("server".equals(this.type)) {
                TcpNioServerConnectionFactory connectionFactory = new TcpNioServerConnectionFactory(this.port);
                this.setCommonAttributes(connectionFactory);
                this.setServerAttributes(connectionFactory);
                connectionFactory.setUsingDirectBuffers(this.usingDirectBuffers);
                connectionFactory.setTcpNioConnectionSupport(this.obtainNioConnectionSupport());
                this.connectionFactory = connectionFactory;
            } else {
                TcpNioClientConnectionFactory connectionFactory = new TcpNioClientConnectionFactory(this.host, this.port);
                this.setCommonAttributes(connectionFactory);
                connectionFactory.setUsingDirectBuffers(this.usingDirectBuffers);
                connectionFactory.setTcpNioConnectionSupport(this.obtainNioConnectionSupport());
                this.connectionFactory = connectionFactory;
            }
        } else if ("server".equals(this.type)) {
            TcpNetServerConnectionFactory connectionFactory = new TcpNetServerConnectionFactory(this.port);
            this.setCommonAttributes(connectionFactory);
            this.setServerAttributes(connectionFactory);
            connectionFactory.setTcpSocketFactorySupport(this.obtainSocketFactorySupport());
            this.connectionFactory = connectionFactory;
        } else {
            TcpNetClientConnectionFactory connectionFactory = new TcpNetClientConnectionFactory(this.host, this.port);
            this.setCommonAttributes(connectionFactory);
            connectionFactory.setTcpSocketFactorySupport(this.obtainSocketFactorySupport());
            this.connectionFactory = connectionFactory;
        }
        return this.connectionFactory;
    }

    private void setCommonAttributes(AbstractConnectionFactory factory) {
        factory.setDeserializer(this.deserializer);
        factory.setInterceptorFactoryChain(this.interceptorFactoryChain);
        factory.setLookupHost(this.lookupHost);
        this.mapper.setApplySequence(this.applySequence);
        factory.setMapper(this.mapper);
        factory.setSerializer(this.serializer);
        factory.setSingleUse(this.singleUse);
        factory.setSoKeepAlive(this.soKeepAlive);
        factory.setSoLinger(this.soLinger);
        factory.setSoReceiveBufferSize(this.soReceiveBufferSize);
        factory.setSoSendBufferSize(this.soSendBufferSize);
        factory.setSoTcpNoDelay(this.soTcpNoDelay);
        factory.setSoTimeout(this.soTimeout);
        factory.setSoTrafficClass(this.soTrafficClass);
        factory.setTaskExecutor(this.taskExecutor);
        factory.setBeanName(this.beanName);
        factory.setTcpSocketSupport(this.socketSupport);
        factory.setApplicationEventPublisher(this.applicationEventPublisher);
        if (this.readDelay != null) {
            factory.setReadDelay(this.readDelay);
        }
    }

    private void setServerAttributes(AbstractServerConnectionFactory factory) {
        factory.setLocalAddress(this.localAddress);
        factory.setBacklog(this.backlog);
    }

    private TcpSocketFactorySupport obtainSocketFactorySupport() {
        if (this.socketFactorySupport != null) {
            return this.socketFactorySupport;
        }
        if (this.sslContextSupport == null) {
            return new DefaultTcpNetSocketFactorySupport();
        }
        DefaultTcpNetSSLSocketFactorySupport socketFactorySupport = new DefaultTcpNetSSLSocketFactorySupport(this.sslContextSupport);
        try {
            socketFactorySupport.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to set up TcpSocketFactorySupport", e);
        }
        return socketFactorySupport;
    }

    private TcpNioConnectionSupport obtainNioConnectionSupport() {
        if (this.nioConnectionSupport != null) {
            return this.nioConnectionSupport;
        }
        if (this.sslContextSupport == null) {
            return new DefaultTcpNioConnectionSupport();
        }
        DefaultTcpNioSSLConnectionSupport connectionSupport = new DefaultTcpNioSSLConnectionSupport(this.sslContextSupport);
        try {
            connectionSupport.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to set up TcpConnectionSupport", e);
        }
        return connectionSupport;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHost(String host) {
        Assert.notNull((Object)host, (String)"Host may not be null");
        this.host = host;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setLocalAddress(String localAddress) {
        Assert.notNull((Object)localAddress, (String)"LocalAddress may not be null");
        this.localAddress = localAddress;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setSoReceiveBufferSize(int soReceiveBufferSize) {
        this.soReceiveBufferSize = soReceiveBufferSize;
    }

    public void setSoSendBufferSize(int soSendBufferSize) {
        this.soSendBufferSize = soSendBufferSize;
    }

    public void setSoTcpNoDelay(boolean soTcpNoDelay) {
        this.soTcpNoDelay = soTcpNoDelay;
    }

    public void setSoLinger(int soLinger) {
        this.soLinger = soLinger;
    }

    public void setSoKeepAlive(boolean soKeepAlive) {
        this.soKeepAlive = soKeepAlive;
    }

    public void setSoTrafficClass(int soTrafficClass) {
        this.soTrafficClass = soTrafficClass;
    }

    public void setUsingNio(boolean usingNio) {
        this.usingNio = usingNio;
    }

    public void setUsingDirectBuffers(boolean usingDirectBuffers) {
        this.usingDirectBuffers = usingDirectBuffers;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        Assert.notNull((Object)taskExecutor, (String)"Executor may not be null");
        this.taskExecutor = taskExecutor;
    }

    public void setDeserializer(Deserializer<?> deserializer) {
        Assert.notNull(deserializer, (String)"Deserializer may not be null");
        this.deserializer = deserializer;
    }

    public void setSerializer(Serializer<?> serializer) {
        Assert.notNull(serializer, (String)"Serializer may not be null");
        this.serializer = serializer;
    }

    public void setMapper(TcpMessageMapper mapper) {
        Assert.notNull((Object)mapper, (String)"TcpMessageMapper may not be null");
        this.mapper = mapper;
        this.mapperSet = true;
    }

    public void setSingleUse(boolean singleUse) {
        this.singleUse = singleUse;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public void setInterceptorFactoryChain(TcpConnectionInterceptorFactoryChain interceptorFactoryChain) {
        Assert.notNull((Object)interceptorFactoryChain, (String)"InterceptorFactoryChain may not be null");
        this.interceptorFactoryChain = interceptorFactoryChain;
    }

    public void setLookupHost(boolean lookupHost) {
        this.lookupHost = lookupHost;
    }

    public void start() {
        this.connectionFactory.start();
    }

    public void stop() {
        this.connectionFactory.stop();
    }

    public int getPhase() {
        return this.connectionFactory.getPhase();
    }

    public boolean isAutoStartup() {
        return this.connectionFactory.isAutoStartup();
    }

    public void stop(Runnable callback) {
        this.connectionFactory.stop(callback);
    }

    public boolean isRunning() {
        return this.connectionFactory.isRunning();
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setApplySequence(boolean applySequence) {
        this.applySequence = applySequence;
    }

    public void setReadDelay(long readDelay) {
        this.readDelay = readDelay;
    }

    public void setSslContextSupport(TcpSSLContextSupport sslContextSupport) {
        Assert.notNull((Object)sslContextSupport, (String)"TcpSSLConstextSupport may not be null");
        this.sslContextSupport = sslContextSupport;
    }

    public void setSocketSupport(TcpSocketSupport tcpSocketSupport) {
        Assert.notNull((Object)tcpSocketSupport, (String)"TcpSocketSupport may not be null");
        this.socketSupport = tcpSocketSupport;
    }

    public void setNioConnectionSupport(TcpNioConnectionSupport tcpNioSupport) {
        Assert.notNull((Object)tcpNioSupport, (String)"TcpNioConnectionSupport may not be null");
        this.nioConnectionSupport = tcpNioSupport;
    }

    public void setSocketFactorySupport(TcpSocketFactorySupport tcpSocketFactorySupport) {
        Assert.notNull((Object)tcpSocketFactorySupport, (String)"TcpSocketFactorySupport may not be null");
        this.socketFactorySupport = tcpSocketFactorySupport;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

