/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.integration.context.OrderlyShutdownCapable;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.ip.tcp.connection.AbstractClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.connection.AbstractServerConnectionFactory;
import org.springframework.integration.ip.tcp.connection.ClientModeCapable;
import org.springframework.integration.ip.tcp.connection.ClientModeConnectionManager;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpConnectionFailedCorrelationEvent;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.connection.TcpSender;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.util.Assert;

public class TcpInboundGateway
extends MessagingGatewaySupport
implements TcpListener,
TcpSender,
ClientModeCapable,
OrderlyShutdownCapable {
    private volatile AbstractServerConnectionFactory serverConnectionFactory;
    private volatile AbstractClientConnectionFactory clientConnectionFactory;
    private final Map<String, TcpConnection> connections = new ConcurrentHashMap<String, TcpConnection>();
    private volatile boolean isClientMode;
    private volatile boolean isSingleUse;
    private volatile long retryInterval = 60000L;
    private volatile ScheduledFuture<?> scheduledFuture;
    private volatile ClientModeConnectionManager clientModeConnectionManager;
    private volatile boolean active;
    private volatile boolean shuttingDown;
    private final AtomicInteger activeCount = new AtomicInteger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onMessage(Message<?> message) {
        boolean isErrorMessage = message instanceof ErrorMessage;
        try {
            if (this.shuttingDown) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Inbound message ignored; shutting down; " + message.toString()));
                }
            } else {
                if (isErrorMessage) {
                    boolean bl = false;
                    return bl;
                }
                this.activeCount.incrementAndGet();
                try {
                    boolean bl = this.doOnMessage(message);
                    return bl;
                }
                finally {
                    this.activeCount.decrementAndGet();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            String connectionId = (String)message.getHeaders().get((Object)"ip_connectionId");
            if (connectionId != null && !isErrorMessage && this.isSingleUse) {
                if (this.serverConnectionFactory != null) {
                    this.serverConnectionFactory.closeConnection(connectionId);
                } else {
                    this.clientConnectionFactory.closeConnection(connectionId);
                }
            }
        }
    }

    private boolean doOnMessage(Message<?> message) {
        Message reply = this.sendAndReceiveMessage(message);
        if (reply == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("null reply received for " + message + " nothing to send"));
            }
            return false;
        }
        String connectionId = (String)message.getHeaders().get((Object)"ip_connectionId");
        TcpConnection connection = null;
        if (connectionId != null) {
            connection = this.connections.get(connectionId);
        }
        if (connection == null) {
            this.publishNoConnectionEvent(message, connectionId);
            this.logger.error((Object)("Connection not found when processing reply " + reply + " for " + message));
            return false;
        }
        try {
            connection.send(reply);
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to send reply", (Throwable)e);
        }
        return false;
    }

    private void publishNoConnectionEvent(Message<?> message, String connectionId) {
        AbstractConnectionFactory cf = this.serverConnectionFactory != null ? this.serverConnectionFactory : this.clientConnectionFactory;
        ApplicationEventPublisher applicationEventPublisher = cf.getApplicationEventPublisher();
        if (applicationEventPublisher != null) {
            applicationEventPublisher.publishEvent((ApplicationEvent)new TcpConnectionFailedCorrelationEvent(this, connectionId, new MessagingException(message, "Connection not found to process reply.")));
        }
    }

    public boolean isListening() {
        return this.serverConnectionFactory != null && this.serverConnectionFactory.isListening();
    }

    public void setConnectionFactory(AbstractConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"Connection factory must not be null");
        if (connectionFactory instanceof AbstractServerConnectionFactory) {
            this.serverConnectionFactory = (AbstractServerConnectionFactory)connectionFactory;
        } else if (connectionFactory instanceof AbstractClientConnectionFactory) {
            this.clientConnectionFactory = (AbstractClientConnectionFactory)connectionFactory;
        } else {
            throw new IllegalArgumentException("Connection factory must be either an AbstractServerConnectionFactory or an AbstractClientConnectionFactory");
        }
        connectionFactory.registerListener(this);
        connectionFactory.registerSender(this);
        this.isSingleUse = connectionFactory.isSingleUse();
    }

    @Override
    public void addNewConnection(TcpConnection connection) {
        this.connections.put(connection.getConnectionId(), connection);
    }

    @Override
    public void removeDeadConnection(TcpConnection connection) {
        this.connections.remove(connection.getConnectionId());
    }

    public String getComponentType() {
        return "ip:tcp-inbound-gateway";
    }

    protected void onInit() throws Exception {
        super.onInit();
        if (this.isClientMode) {
            Assert.notNull((Object)this.clientConnectionFactory, (String)"For client-mode, connection factory must be type='client'");
            Assert.isTrue((!this.clientConnectionFactory.isSingleUse() ? 1 : 0) != 0, (String)"For client-mode, connection factory must have single-use='false'");
        }
    }

    protected void doStart() {
        super.doStart();
        if (!this.active) {
            this.active = true;
            this.shuttingDown = false;
            if (this.serverConnectionFactory != null) {
                this.serverConnectionFactory.start();
            }
            if (this.clientConnectionFactory != null) {
                this.clientConnectionFactory.start();
            }
            if (this.isClientMode) {
                ClientModeConnectionManager manager;
                this.clientModeConnectionManager = manager = new ClientModeConnectionManager(this.clientConnectionFactory);
                Assert.state((this.getTaskScheduler() != null ? 1 : 0) != 0, (String)"Client mode requires a task scheduler");
                this.scheduledFuture = this.getTaskScheduler().scheduleAtFixedRate((Runnable)manager, this.retryInterval);
            }
        }
    }

    protected void doStop() {
        super.doStop();
        if (this.active) {
            this.active = false;
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(true);
            }
            this.clientModeConnectionManager = null;
            if (this.clientConnectionFactory != null) {
                this.clientConnectionFactory.stop();
            }
            if (this.serverConnectionFactory != null) {
                this.serverConnectionFactory.stop();
            }
        }
    }

    @Override
    public boolean isClientMode() {
        return this.isClientMode;
    }

    public void setClientMode(boolean isClientMode) {
        this.isClientMode = isClientMode;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    @Override
    public boolean isClientModeConnected() {
        if (this.isClientMode && this.clientModeConnectionManager != null) {
            return this.clientModeConnectionManager.isConnected();
        }
        return false;
    }

    @Override
    public void retryConnection() {
        if (this.active && this.isClientMode && this.clientModeConnectionManager != null) {
            this.clientModeConnectionManager.run();
        }
    }

    public int beforeShutdown() {
        this.shuttingDown = true;
        return this.activeCount.get();
    }

    public int afterShutdown() {
        this.stop();
        return this.activeCount.get();
    }
}

