/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.udp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import org.springframework.integration.ip.udp.UnicastSendingMessageHandler;
import org.springframework.messaging.Message;

public class MulticastSendingMessageHandler
extends UnicastSendingMessageHandler {
    private int timeToLive = -1;
    private String localAddress;
    private volatile MulticastSocket multicastSocket;

    public MulticastSendingMessageHandler(String address, int port) {
        super(address, port);
    }

    public MulticastSendingMessageHandler(String address, int port, boolean lengthCheck) {
        super(address, port, lengthCheck);
    }

    public MulticastSendingMessageHandler(String address, int port, boolean acknowledge, String ackHost, int ackPort, int ackTimeout) {
        super(address, port, acknowledge, ackHost, ackPort, ackTimeout);
    }

    public MulticastSendingMessageHandler(String address, int port, boolean lengthCheck, boolean acknowledge, String ackHost, int ackPort, int ackTimeout) {
        super(address, port, lengthCheck, acknowledge, ackHost, ackPort, ackTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DatagramSocket getSocket() throws IOException {
        if (this.getTheSocket() == null) {
            MulticastSendingMessageHandler multicastSendingMessageHandler = this;
            synchronized (multicastSendingMessageHandler) {
                this.createSocket();
            }
        }
        return this.getTheSocket();
    }

    private void createSocket() throws IOException {
        if (this.getTheSocket() == null) {
            MulticastSocket socket;
            if (this.isAcknowledge()) {
                int ackPort = this.getAckPort();
                if (this.localAddress == null) {
                    socket = ackPort == 0 ? new MulticastSocket() : new MulticastSocket(ackPort);
                } else {
                    InetAddress whichNic = InetAddress.getByName(this.localAddress);
                    socket = new MulticastSocket(new InetSocketAddress(whichNic, ackPort));
                }
                if (this.getSoReceiveBufferSize() > 0) {
                    socket.setReceiveBufferSize(this.getSoReceiveBufferSize());
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Listening for acks on port: " + socket.getLocalPort()));
                }
                this.setSocket(socket);
                this.updateAckAddress();
            } else {
                socket = new MulticastSocket();
                this.setSocket(socket);
            }
            if (this.timeToLive >= 0) {
                socket.setTimeToLive(this.timeToLive);
            }
            this.setSocketAttributes(socket);
            if (this.localAddress != null) {
                InetAddress whichNic = InetAddress.getByName(this.localAddress);
                socket.setInterface(whichNic);
            }
            this.multicastSocket = socket;
        }
    }

    public void setMinAcksForSuccess(int minAcksForSuccess) {
        this.setAckCounter(minAcksForSuccess);
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    @Override
    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    @Override
    protected void convertAndSend(Message<?> message) throws Exception {
        super.convertAndSend(message);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Sent packet to " + this.multicastSocket.getInterface()));
        }
    }
}

