/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.integration.ip.tcp.connection.TcpNioConnection;
import org.springframework.integration.ip.tcp.connection.TcpNioConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpNioSSLConnection;
import org.springframework.integration.ip.tcp.connection.TcpSSLContextSupport;
import org.springframework.util.Assert;

public class DefaultTcpNioSSLConnectionSupport
implements TcpNioConnectionSupport {
    private final SSLContext sslContext;

    public DefaultTcpNioSSLConnectionSupport(TcpSSLContextSupport sslContextSupport) {
        Assert.notNull((Object)sslContextSupport, (String)"TcpSSLContextSupport must not be null");
        try {
            this.sslContext = sslContextSupport.getSSLContext();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Invalid TcpSSLContextSupport - it failed to provide an SSLContext", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid TcpSSLContextSupport - it failed to provide an SSLContext", e);
        }
        Assert.notNull((Object)this.sslContext, (String)"SSLContext retrieved from context support must not be null");
    }

    @Override
    public TcpNioConnection createNewConnection(SocketChannel socketChannel, boolean server, boolean lookupHost, ApplicationEventPublisher applicationEventPublisher, String connectionFactoryName) throws Exception {
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        this.postProcessSSLEngine(sslEngine);
        TcpNioSSLConnection tcpNioSSLConnection = new TcpNioSSLConnection(socketChannel, server, lookupHost, applicationEventPublisher, connectionFactoryName, sslEngine);
        tcpNioSSLConnection.init();
        return tcpNioSSLConnection;
    }

    @Deprecated
    public void afterPropertiesSet() throws Exception {
    }

    protected void postProcessSSLEngine(SSLEngine sslEngine) {
    }
}

