/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.integration.ip.tcp.connection.NoListenerException;
import org.springframework.integration.ip.tcp.connection.TcpConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.serializer.SoftEndOfStreamException;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.scheduling.SchedulingAwareRunnable;

public class TcpNetConnection
extends TcpConnectionSupport
implements SchedulingAwareRunnable {
    private final Socket socket;
    private volatile OutputStream socketOutputStream;
    private volatile long lastRead = System.currentTimeMillis();
    private volatile long lastSend;

    public TcpNetConnection(Socket socket, boolean server, boolean lookupHost, ApplicationEventPublisher applicationEventPublisher, String connectionFactoryName) {
        super(socket, server, lookupHost, applicationEventPublisher, connectionFactoryName);
        this.socket = socket;
    }

    public boolean isLongLived() {
        return true;
    }

    @Override
    public void close() {
        this.setNoReadErrorOnClose(true);
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.close();
    }

    @Override
    public boolean isOpen() {
        return !this.socket.isClosed();
    }

    @Override
    public synchronized void send(Message<?> message) throws Exception {
        if (this.socketOutputStream == null) {
            int writeBufferSize = this.socket.getSendBufferSize();
            this.socketOutputStream = new BufferedOutputStream(this.socket.getOutputStream(), writeBufferSize > 0 ? writeBufferSize : 8192);
        }
        Object object = this.getMapper().fromMessage(message);
        this.lastSend = System.currentTimeMillis();
        try {
            this.getSerializer().serialize(object, this.socketOutputStream);
            this.socketOutputStream.flush();
        }
        catch (Exception e) {
            this.publishConnectionExceptionEvent(new MessagingException(message, "Failed TCP serialization", (Throwable)e));
            this.closeConnection(true);
            throw e;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.getConnectionId() + " Message sent " + message));
        }
    }

    @Override
    public Object getPayload() throws Exception {
        return this.getDeserializer().deserialize(this.socket.getInputStream());
    }

    @Override
    public int getPort() {
        return this.socket.getPort();
    }

    @Override
    public Object getDeserializerStateKey() {
        try {
            return this.socket.getInputStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public SSLSession getSslSession() {
        if (this.socket instanceof SSLSocket) {
            return ((SSLSocket)this.socket).getSession();
        }
        return null;
    }

    @Override
    public void run() {
        boolean okToRun = true;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.getConnectionId() + " Reading..."));
        }
        while (okToRun) {
            Message<?> message;
            block9: {
                message = null;
                try {
                    message = this.getMapper().toMessage(this);
                    this.lastRead = System.currentTimeMillis();
                }
                catch (Exception e) {
                    this.publishConnectionExceptionEvent(e);
                    if (!this.handleReadException(e)) break block9;
                    okToRun = false;
                }
            }
            if (!okToRun || message == null) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message received " + message));
            }
            try {
                TcpListener listener = this.getListener();
                if (listener == null) {
                    throw new NoListenerException("No listener");
                }
                listener.onMessage(message);
            }
            catch (NoListenerException nle) {
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn((Object)("Unexpected message - no endpoint registered with connection interceptor: " + this.getConnectionId() + " - " + message));
            }
            catch (Exception e2) {
                this.logger.error((Object)("Exception sending message: " + message), (Throwable)e2);
            }
        }
    }

    protected boolean handleReadException(Exception e) {
        boolean doClose = true;
        if (!this.isServer() && e instanceof SocketTimeoutException) {
            long now = System.currentTimeMillis();
            try {
                int soTimeout = this.socket.getSoTimeout();
                if (now - this.lastSend < (long)soTimeout && now - this.lastRead < (long)(soTimeout * 2)) {
                    doClose = false;
                }
                if (!doClose && this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Skipping a socket timeout because we have a recent send " + this.getConnectionId()));
                }
            }
            catch (SocketException e1) {
                this.logger.error((Object)"Error accessing soTimeout", (Throwable)e1);
            }
        }
        if (doClose) {
            boolean noReadErrorOnClose = this.isNoReadErrorOnClose();
            this.closeConnection(true);
            if (!(e instanceof SoftEndOfStreamException)) {
                if (e instanceof SocketTimeoutException) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Closed socket after timeout:" + this.getConnectionId()));
                    }
                } else if (noReadErrorOnClose) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Read exception " + this.getConnectionId()), (Throwable)e);
                    } else if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Read exception " + this.getConnectionId() + " " + e.getClass().getSimpleName() + ":" + (e.getCause() != null ? e.getCause() + ":" : "") + e.getMessage()));
                    }
                } else if (this.logger.isTraceEnabled()) {
                    this.logger.error((Object)("Read exception " + this.getConnectionId()), (Throwable)e);
                } else {
                    this.logger.error((Object)("Read exception " + this.getConnectionId() + " " + e.getClass().getSimpleName() + ":" + (e.getCause() != null ? e.getCause() + ":" : "") + e.getMessage()));
                }
                this.sendExceptionToListener(e);
            }
        }
        return doClose;
    }
}

