/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.integration.ip.tcp.serializer.AbstractPooledBufferByteArraySerializer;
import org.springframework.integration.ip.tcp.serializer.SoftEndOfStreamException;

public class ByteArraySingleTerminatorSerializer
extends AbstractPooledBufferByteArraySerializer {
    private final byte terminator;

    public ByteArraySingleTerminatorSerializer(byte delimiter) {
        this.terminator = delimiter;
    }

    @Override
    protected byte[] doDeserialize(InputStream inputStream, byte[] buffer) throws IOException {
        int n = 0;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Available to read:" + inputStream.available()));
        }
        try {
            block7: {
                do {
                    int bite;
                    if ((bite = inputStream.read()) < 0 && n == 0) {
                        throw new SoftEndOfStreamException("Stream closed between payloads");
                    }
                    this.checkClosure(bite);
                    if (bite == this.terminator) break block7;
                    buffer[n++] = (byte)bite;
                } while (n < this.maxMessageSize);
                throw new IOException("Terminator '0x" + Integer.toHexString(this.terminator & 0xFF) + "' not found before max message length: " + this.maxMessageSize);
            }
            return this.copyToSizedArray(buffer, n);
        }
        catch (SoftEndOfStreamException e) {
            throw e;
        }
        catch (IOException e) {
            this.publishEvent(e, buffer, n);
            throw e;
        }
        catch (RuntimeException e) {
            this.publishEvent(e, buffer, n);
            throw e;
        }
    }

    public void serialize(byte[] bytes, OutputStream outputStream) throws IOException {
        outputStream.write(bytes);
        outputStream.write(this.terminator);
    }
}

