/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.amqp;

import java.util.concurrent.Executor;
import org.aopalliance.aop.Advice;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.integration.amqp.inbound.AmqpInboundGateway;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.dsl.core.MessagingGatewaySpec;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ErrorHandler;

public class AmqpInboundGatewaySpec
extends MessagingGatewaySpec<AmqpInboundGatewaySpec, AmqpInboundGateway> {
    private final SimpleMessageListenerContainer listenerContainer;
    private final DefaultAmqpHeaderMapper headerMapper = new DefaultAmqpHeaderMapper();

    AmqpInboundGatewaySpec(SimpleMessageListenerContainer listenerContainer) {
        super(new AmqpInboundGateway((AbstractMessageListenerContainer)listenerContainer));
        this.listenerContainer = listenerContainer;
        ((AmqpInboundGateway)this.target).setHeaderMapper((AmqpHeaderMapper)this.headerMapper);
    }

    public AmqpInboundGatewaySpec acknowledgeMode(AcknowledgeMode acknowledgeMode) {
        this.listenerContainer.setAcknowledgeMode(acknowledgeMode);
        return this;
    }

    public AmqpInboundGatewaySpec addQueueNames(String ... queueName) {
        this.listenerContainer.addQueueNames(queueName);
        return this;
    }

    public AmqpInboundGatewaySpec addQueues(Queue ... queues) {
        this.listenerContainer.addQueues(queues);
        return this;
    }

    public AmqpInboundGatewaySpec errorHandler(ErrorHandler errorHandler) {
        this.listenerContainer.setErrorHandler(errorHandler);
        return this;
    }

    public AmqpInboundGatewaySpec channelTransacted(boolean transactional) {
        this.listenerContainer.setChannelTransacted(transactional);
        return this;
    }

    public AmqpInboundGatewaySpec adviceChain(Advice ... adviceChain) {
        this.listenerContainer.setAdviceChain(adviceChain);
        return this;
    }

    public AmqpInboundGatewaySpec recoveryInterval(long recoveryInterval) {
        this.listenerContainer.setRecoveryInterval(recoveryInterval);
        return this;
    }

    public AmqpInboundGatewaySpec concurrentConsumers(int concurrentConsumers) {
        this.listenerContainer.setConcurrentConsumers(concurrentConsumers);
        return this;
    }

    public AmqpInboundGatewaySpec maxConcurrentConsumers(int maxConcurrentConsumers) {
        this.listenerContainer.setMaxConcurrentConsumers(maxConcurrentConsumers);
        return this;
    }

    public AmqpInboundGatewaySpec exclusive(boolean exclusive) {
        this.listenerContainer.setExclusive(exclusive);
        return this;
    }

    public AmqpInboundGatewaySpec startConsumerMinInterval(long startConsumerMinInterval) {
        this.listenerContainer.setStartConsumerMinInterval(startConsumerMinInterval);
        return this;
    }

    public AmqpInboundGatewaySpec stopConsumerMinInterval(long stopConsumerMinInterval) {
        this.listenerContainer.setStopConsumerMinInterval(stopConsumerMinInterval);
        return this;
    }

    public AmqpInboundGatewaySpec consecutiveActiveTrigger(int consecutiveActiveTrigger) {
        this.listenerContainer.setConsecutiveActiveTrigger(consecutiveActiveTrigger);
        return this;
    }

    public AmqpInboundGatewaySpec consecutiveIdleTrigger(int consecutiveIdleTrigger) {
        this.listenerContainer.setConsecutiveIdleTrigger(consecutiveIdleTrigger);
        return this;
    }

    public AmqpInboundGatewaySpec receiveTimeout(long receiveTimeout) {
        this.listenerContainer.setReceiveTimeout(receiveTimeout);
        return this;
    }

    public AmqpInboundGatewaySpec shutdownTimeout(long shutdownTimeout) {
        this.listenerContainer.setShutdownTimeout(shutdownTimeout);
        return this;
    }

    public AmqpInboundGatewaySpec taskExecutor(Executor taskExecutor) {
        this.listenerContainer.setTaskExecutor(taskExecutor);
        return this;
    }

    public AmqpInboundGatewaySpec prefetchCount(int prefetchCount) {
        this.listenerContainer.setPrefetchCount(prefetchCount);
        return this;
    }

    public AmqpInboundGatewaySpec txSize(int txSize) {
        this.listenerContainer.setTxSize(txSize);
        return this;
    }

    public AmqpInboundGatewaySpec transactionManager(PlatformTransactionManager transactionManager) {
        this.listenerContainer.setTransactionManager(transactionManager);
        return this;
    }

    public AmqpInboundGatewaySpec defaultRequeueRejected(boolean defaultRequeueRejected) {
        this.listenerContainer.setDefaultRequeueRejected(defaultRequeueRejected);
        return this;
    }

    public AmqpInboundGatewaySpec messageConverter(MessageConverter messageConverter) {
        ((AmqpInboundGateway)this.target).setMessageConverter(messageConverter);
        return this;
    }

    public AmqpInboundGatewaySpec headerMapper(AmqpHeaderMapper headerMapper) {
        ((AmqpInboundGateway)this.target).setHeaderMapper(headerMapper);
        return this;
    }

    public AmqpInboundGatewaySpec mappedRequestHeaders(String ... headers) {
        this.headerMapper.setRequestHeaderNames(headers);
        return this;
    }

    public AmqpInboundGatewaySpec mappedReplyHeaders(String ... headers) {
        this.headerMapper.setReplyHeaderNames(headers);
        return this;
    }
}

