/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.core;

import org.springframework.beans.factory.BeanNameAware;
import org.springframework.core.ResolvableType;
import org.springframework.integration.dsl.core.IntegrationComponentSpec;
import org.springframework.integration.dsl.support.PollerSpec;
import org.springframework.integration.dsl.tuple.Tuple;
import org.springframework.integration.dsl.tuple.Tuple2;
import org.springframework.integration.scheduling.PollerMetadata;

public abstract class EndpointSpec<S extends EndpointSpec<S, F, H>, F extends BeanNameAware, H>
extends IntegrationComponentSpec<S, Tuple2<F, H>> {
    protected EndpointSpec(H handler) {
        try {
            Class fClass = ResolvableType.forClass(this.getClass()).as(EndpointSpec.class).resolveGenerics()[1];
            BeanNameAware endpointFactoryBean = (BeanNameAware)fClass.newInstance();
            this.target = Tuple.of(endpointFactoryBean, handler);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public S id(String id) {
        ((BeanNameAware)((Tuple2)this.target).getT1()).setBeanName(id);
        return (S)((EndpointSpec)super.id(id));
    }

    public abstract S phase(int var1);

    public abstract S autoStartup(boolean var1);

    public abstract S poller(PollerMetadata var1);

    public S poller(PollerSpec pollerMetadataSpec) {
        return this.poller((PollerMetadata)pollerMetadataSpec.get());
    }

    @Override
    protected final Tuple2<F, H> doGet() {
        throw new UnsupportedOperationException();
    }
}

