/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.core;

import java.util.Collection;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.channel.FixedSubscriberChannel;
import org.springframework.integration.config.ConsumerEndpointFactoryBean;
import org.springframework.integration.config.SourcePollingChannelAdapterFactoryBean;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.dsl.SourcePollingChannelAdapterSpec;
import org.springframework.integration.dsl.core.ConsumerEndpointSpec;
import org.springframework.integration.dsl.support.MessageChannelReference;
import org.springframework.integration.dsl.tuple.Tuple2;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class IntegrationFlowBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private ConfigurableListableBeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory, (String)"To use Spring Integration Java DSL the 'beanFactory' has to be an instance of 'ConfigurableListableBeanFactory'. Consider using 'GenericApplicationContext' implementation.");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof IntegrationFlowBuilder.StandardIntegrationFlow) {
            return this.processStandardIntegrationFlow((IntegrationFlowBuilder.StandardIntegrationFlow)bean, beanName);
        }
        if (bean instanceof IntegrationFlow) {
            return this.processIntegrationFlowImpl((IntegrationFlow)bean, beanName);
        }
        return bean;
    }

    private Object processStandardIntegrationFlow(IntegrationFlowBuilder.StandardIntegrationFlow flow, String beanName) {
        String flowNamePrefix = beanName + ".";
        int channelNameIndex = 0;
        for (Object component : flow.getIntegrationComponents()) {
            if (component instanceof ConsumerEndpointSpec) {
                String endpointBeanName;
                ConsumerEndpointSpec endpointSpec = (ConsumerEndpointSpec)component;
                MessageHandler messageHandler = (MessageHandler)((Tuple2)endpointSpec.get()).getT2();
                ConsumerEndpointFactoryBean endpoint = (ConsumerEndpointFactoryBean)((Tuple2)endpointSpec.get()).getT1();
                String id = endpointSpec.getId();
                Collection messageHandlers = this.beanFactory.getBeansOfType(MessageHandler.class, false, false).values();
                if (!messageHandlers.contains(messageHandler)) {
                    String[] stringArray;
                    String handlerBeanName = this.generateBeanName(messageHandler);
                    if (id != null) {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = id + ".handler";
                    } else {
                        stringArray = null;
                    }
                    String[] handlerAlias = stringArray;
                    this.registerComponent(messageHandler, handlerBeanName);
                    if (handlerAlias != null) {
                        for (String alias : handlerAlias) {
                            this.beanFactory.registerAlias(handlerBeanName, alias);
                        }
                    }
                }
                if ((endpointBeanName = id) == null) {
                    endpointBeanName = this.generateBeanName(endpoint);
                }
                this.registerComponent(endpoint, endpointBeanName);
                continue;
            }
            if (component instanceof MessageChannel) {
                String channelBeanName;
                Collection messageChannels = this.beanFactory.getBeansOfType(MessageChannel.class, false, false).values();
                if (messageChannels.contains(component)) continue;
                if (component instanceof AbstractMessageChannel) {
                    channelBeanName = ((AbstractMessageChannel)component).getComponentName();
                    if (channelBeanName == null) {
                        channelBeanName = flowNamePrefix + "channel" + "#" + channelNameIndex++;
                    }
                    this.registerComponent(component, channelBeanName);
                    continue;
                }
                if (component instanceof MessageChannelReference) {
                    channelBeanName = ((MessageChannelReference)component).getName();
                    if (this.beanFactory.containsBean(channelBeanName)) continue;
                    DirectChannel directChannel = new DirectChannel();
                    this.registerComponent(directChannel, channelBeanName);
                    continue;
                }
                if (!(component instanceof FixedSubscriberChannel)) continue;
                FixedSubscriberChannel fixedSubscriberChannel = (FixedSubscriberChannel)component;
                String channelBeanName2 = fixedSubscriberChannel.getComponentName();
                if ("Unnamed fixed subscriber channel".equals(channelBeanName2)) {
                    channelBeanName2 = flowNamePrefix + "channel" + "#" + channelNameIndex++;
                }
                this.registerComponent(component, channelBeanName2);
                continue;
            }
            if (component instanceof SourcePollingChannelAdapterSpec) {
                SourcePollingChannelAdapterSpec spec = (SourcePollingChannelAdapterSpec)component;
                SourcePollingChannelAdapterFactoryBean pollingChannelAdapterFactoryBean = (SourcePollingChannelAdapterFactoryBean)((Tuple2)spec.get()).getT1();
                String id = spec.getId();
                if (!StringUtils.hasText((String)id)) {
                    id = this.generateBeanName(pollingChannelAdapterFactoryBean);
                }
                this.registerComponent(pollingChannelAdapterFactoryBean, id);
                MessageSource messageSource = (MessageSource)((Tuple2)spec.get()).getT2();
                if (this.beanFactory.getBeansOfType(MessageSource.class, false, false).values().contains(messageSource)) continue;
                String messageSourceId = id + ".source";
                if (messageSource instanceof NamedComponent && ((NamedComponent)messageSource).getComponentName() != null) {
                    messageSourceId = ((NamedComponent)messageSource).getComponentName();
                }
                this.registerComponent(messageSource, messageSourceId);
                continue;
            }
            if (this.beanFactory.getBeansOfType(AopUtils.getTargetClass((Object)component), false, false).values().contains(component)) continue;
            this.registerComponent(component, this.generateBeanName(component));
        }
        return flow;
    }

    private Object processIntegrationFlowImpl(IntegrationFlow flow, String beanName) {
        IntegrationFlowBuilder flowBuilder = IntegrationFlows.from(beanName + ".input");
        flow.define(flowBuilder);
        return this.processStandardIntegrationFlow(flowBuilder.get(), beanName);
    }

    private void registerComponent(Object component, String beanName) {
        this.beanFactory.registerSingleton(beanName, component);
        this.beanFactory.initializeBean(component, beanName);
    }

    private String generateBeanName(Object instance) {
        if (instance instanceof NamedComponent && ((NamedComponent)instance).getComponentName() != null) {
            return ((NamedComponent)instance).getComponentName();
        }
        String generatedBeanName = instance.getClass().getName();
        String id = instance.getClass().getName();
        int counter = -1;
        while (counter == -1 || this.beanFactory.containsBean(id)) {
            id = generatedBeanName + "#" + ++counter;
        }
        return id;
    }
}

