/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.support;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import org.aopalliance.aop.Advice;
import org.springframework.integration.dsl.core.IntegrationComponentSpec;
import org.springframework.integration.scheduling.PollerMetadata;
import org.springframework.integration.transaction.TransactionSynchronizationFactory;
import org.springframework.scheduling.Trigger;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.MatchAlwaysTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.ErrorHandler;

public final class PollerSpec
extends IntegrationComponentSpec<PollerSpec, PollerMetadata> {
    private final PollerMetadata pollerMetadata = new PollerMetadata();
    private final List<Advice> adviceChain = new LinkedList<Advice>();

    PollerSpec(Trigger trigger) {
        this.pollerMetadata.setTrigger(trigger);
    }

    public PollerSpec transactionSynchronizationFactory(TransactionSynchronizationFactory transactionSynchronizationFactory) {
        this.pollerMetadata.setTransactionSynchronizationFactory(transactionSynchronizationFactory);
        return this;
    }

    public PollerSpec errorHandler(ErrorHandler errorHandler) {
        this.pollerMetadata.setErrorHandler(errorHandler);
        return this;
    }

    public PollerSpec maxMessagesPerPoll(long maxMessagesPerPoll) {
        this.pollerMetadata.setMaxMessagesPerPoll(maxMessagesPerPoll);
        return this;
    }

    public PollerSpec receiveTimeout(long receiveTimeout) {
        this.pollerMetadata.setReceiveTimeout(receiveTimeout);
        return this;
    }

    public PollerSpec advice(Advice ... advice) {
        this.adviceChain.addAll(Arrays.asList(advice));
        return this;
    }

    public PollerSpec transactional(PlatformTransactionManager transactionManager) {
        return this.advice(new Advice[]{new TransactionInterceptor(transactionManager, (TransactionAttributeSource)new MatchAlwaysTransactionAttributeSource())});
    }

    public PollerSpec taskExecutor(Executor taskExecutor) {
        this.pollerMetadata.setTaskExecutor(taskExecutor);
        return this;
    }

    public PollerSpec sendTimeout(long sendTimeout) {
        this.pollerMetadata.setSendTimeout(sendTimeout);
        return this;
    }

    @Override
    protected PollerMetadata doGet() {
        this.pollerMetadata.setAdviceChain(this.adviceChain);
        return this.pollerMetadata;
    }
}

