/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.file;

import java.io.File;
import org.springframework.integration.dsl.core.MessageHandlerSpec;
import org.springframework.integration.dsl.support.Function;
import org.springframework.integration.dsl.support.FunctionExpression;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.filters.RegexPatternFileListFilter;
import org.springframework.integration.file.filters.SimplePatternFileListFilter;
import org.springframework.integration.file.remote.gateway.AbstractRemoteFileOutboundGateway;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public abstract class RemoteFileOutboundGatewaySpec<F, S extends RemoteFileOutboundGatewaySpec<F, S>>
extends MessageHandlerSpec<S, AbstractRemoteFileOutboundGateway<F>> {
    private FileListFilter<F> filter;
    private FileListFilter<File> mputFilter;

    protected RemoteFileOutboundGatewaySpec(AbstractRemoteFileOutboundGateway<F> outboundGateway) {
        this.target = outboundGateway;
    }

    public S options(String options) {
        ((AbstractRemoteFileOutboundGateway)this.target).setOptions(options);
        return (S)((RemoteFileOutboundGatewaySpec)this._this());
    }

    public S options(AbstractRemoteFileOutboundGateway.Option ... options) {
        Assert.noNullElements((Object[])options);
        StringBuilder optionsString = new StringBuilder();
        for (AbstractRemoteFileOutboundGateway.Option option : options) {
            optionsString.append(option.getOption()).append(" ");
        }
        ((AbstractRemoteFileOutboundGateway)this.target).setOptions(optionsString.toString());
        return (S)((RemoteFileOutboundGatewaySpec)this._this());
    }

    public S remoteFileSeparator(String remoteFileSeparator) {
        ((AbstractRemoteFileOutboundGateway)this.target).setRemoteFileSeparator(remoteFileSeparator);
        return (S)((RemoteFileOutboundGatewaySpec)this._this());
    }

    public S localDirectory(File localDirectory) {
        ((AbstractRemoteFileOutboundGateway)this.target).setLocalDirectory(localDirectory);
        return (S)((RemoteFileOutboundGatewaySpec)this._this());
    }

    public S localDirectoryExpression(String localDirectoryExpression) {
        ((AbstractRemoteFileOutboundGateway)this.target).setLocalDirectoryExpression(PARSER.parseExpression(localDirectoryExpression));
        return (S)((RemoteFileOutboundGatewaySpec)this._this());
    }

    public <P> S localDirectory(Function<Message<P>, String> localDirectoryFunction) {
        ((AbstractRemoteFileOutboundGateway)this.target).setLocalDirectoryExpression(new FunctionExpression<Message<P>>(localDirectoryFunction));
        return (S)((RemoteFileOutboundGatewaySpec)this._this());
    }

    public S autoCreateLocalDirectory(boolean autoCreateLocalDirectory) {
        ((AbstractRemoteFileOutboundGateway)this.target).setAutoCreateLocalDirectory(autoCreateLocalDirectory);
        return (S)((RemoteFileOutboundGatewaySpec)this._this());
    }

    public S temporaryFileSuffix(String temporaryFileSuffix) {
        ((AbstractRemoteFileOutboundGateway)this.target).setTemporaryFileSuffix(temporaryFileSuffix);
        return (S)((RemoteFileOutboundGatewaySpec)this._this());
    }

    public S filter(FileListFilter<F> filter) {
        Assert.isNull(this.filter, (String)("The 'filter' (" + this.filter + ") is already configured for the: " + this));
        this.filter = filter;
        ((AbstractRemoteFileOutboundGateway)this.target).setFilter(filter);
        return (S)((RemoteFileOutboundGatewaySpec)this._this());
    }

    public abstract S patternFileNameFilter(String var1);

    public abstract S regexFileNameFilter(String var1);

    public S mputFilter(FileListFilter<File> filter) {
        Assert.isNull(this.mputFilter, (String)("The 'filter' (" + this.mputFilter + ") is already configured for the: " + this));
        this.mputFilter = filter;
        ((AbstractRemoteFileOutboundGateway)this.target).setMputFilter(filter);
        return (S)((RemoteFileOutboundGatewaySpec)this._this());
    }

    public S patternMputFilter(String pattern) {
        return this.mputFilter((FileListFilter<File>)new SimplePatternFileListFilter(pattern));
    }

    public S regexMpuFilter(String regex) {
        return this.mputFilter((FileListFilter<File>)new RegexPatternFileListFilter(regex));
    }

    public S renameExpression(String expression) {
        ((AbstractRemoteFileOutboundGateway)this.target).setRenameExpression(expression);
        return (S)((RemoteFileOutboundGatewaySpec)this._this());
    }

    public S localFilenameExpression(String localFilenameExpression) {
        ((AbstractRemoteFileOutboundGateway)this.target).setLocalFilenameGeneratorExpression(PARSER.parseExpression(localFilenameExpression));
        return (S)((RemoteFileOutboundGatewaySpec)this._this());
    }

    public <P> S localFilename(Function<Message<P>, String> localFilenameFunction) {
        ((AbstractRemoteFileOutboundGateway)this.target).setLocalFilenameGeneratorExpression(new FunctionExpression<Message<P>>(localFilenameFunction));
        return (S)((RemoteFileOutboundGatewaySpec)this._this());
    }

    @Override
    protected AbstractRemoteFileOutboundGateway<F> doGet() {
        throw new UnsupportedOperationException();
    }
}

