/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.expression.Expression;
import org.springframework.expression.MethodFilter;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.aggregator.AbstractCorrelatingMessageHandler;
import org.springframework.integration.aggregator.AggregatingMessageHandler;
import org.springframework.integration.aggregator.ResequencingMessageHandler;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.channel.FixedSubscriberChannel;
import org.springframework.integration.config.ConsumerEndpointFactoryBean;
import org.springframework.integration.config.SourcePollingChannelAdapterFactoryBean;
import org.springframework.integration.core.GenericSelector;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.dsl.Adapters;
import org.springframework.integration.dsl.AggregatorSpec;
import org.springframework.integration.dsl.Channels;
import org.springframework.integration.dsl.DelayerEndpointSpec;
import org.springframework.integration.dsl.EnricherSpec;
import org.springframework.integration.dsl.FilterEndpointSpec;
import org.springframework.integration.dsl.GatewayEndpointSpec;
import org.springframework.integration.dsl.GenericEndpointSpec;
import org.springframework.integration.dsl.HeaderEnricherSpec;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.dsl.LambdaMessageProcessor;
import org.springframework.integration.dsl.PublishSubscribeSpec;
import org.springframework.integration.dsl.RecipientListRouterSpec;
import org.springframework.integration.dsl.ResequencerSpec;
import org.springframework.integration.dsl.RouterSpec;
import org.springframework.integration.dsl.SourcePollingChannelAdapterSpec;
import org.springframework.integration.dsl.SplitterEndpointSpec;
import org.springframework.integration.dsl.StandardIntegrationFlow;
import org.springframework.integration.dsl.channel.MessageChannelSpec;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.dsl.core.ConsumerEndpointSpec;
import org.springframework.integration.dsl.core.MessageHandlerSpec;
import org.springframework.integration.dsl.support.BeanNameMessageProcessor;
import org.springframework.integration.dsl.support.Consumer;
import org.springframework.integration.dsl.support.FixedSubscriberChannelPrototype;
import org.springframework.integration.dsl.support.Function;
import org.springframework.integration.dsl.support.FunctionExpression;
import org.springframework.integration.dsl.support.GenericHandler;
import org.springframework.integration.dsl.support.MapBuilder;
import org.springframework.integration.dsl.support.MessageChannelReference;
import org.springframework.integration.dsl.support.tuple.Tuple2;
import org.springframework.integration.expression.ControlBusMethodFilter;
import org.springframework.integration.filter.ExpressionEvaluatingSelector;
import org.springframework.integration.filter.MessageFilter;
import org.springframework.integration.filter.MethodInvokingSelector;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.BridgeHandler;
import org.springframework.integration.handler.DelayHandler;
import org.springframework.integration.handler.ExpressionCommandMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.handler.ServiceActivatingHandler;
import org.springframework.integration.router.AbstractMappingMessageRouter;
import org.springframework.integration.router.AbstractMessageRouter;
import org.springframework.integration.router.ExpressionEvaluatingRouter;
import org.springframework.integration.router.MethodInvokingRouter;
import org.springframework.integration.router.RecipientListRouter;
import org.springframework.integration.splitter.AbstractMessageSplitter;
import org.springframework.integration.splitter.DefaultMessageSplitter;
import org.springframework.integration.splitter.ExpressionEvaluatingSplitter;
import org.springframework.integration.splitter.MethodInvokingSplitter;
import org.springframework.integration.store.MessageStore;
import org.springframework.integration.transformer.ClaimCheckInTransformer;
import org.springframework.integration.transformer.ClaimCheckOutTransformer;
import org.springframework.integration.transformer.ContentEnricher;
import org.springframework.integration.transformer.ExpressionEvaluatingTransformer;
import org.springframework.integration.transformer.GenericTransformer;
import org.springframework.integration.transformer.HeaderFilter;
import org.springframework.integration.transformer.MessageTransformingHandler;
import org.springframework.integration.transformer.MethodInvokingTransformer;
import org.springframework.integration.transformer.Transformer;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class IntegrationFlowDefinition<B extends IntegrationFlowDefinition<B>> {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    protected final Set<Object> integrationComponents = new LinkedHashSet<Object>();
    protected MessageChannel currentMessageChannel;
    protected Object currentComponent;

    IntegrationFlowDefinition() {
    }

    B addComponent(Object component) {
        this.integrationComponents.add(component);
        return this._this();
    }

    B addComponents(Collection<Object> components) {
        if (components != null) {
            for (Object component : components) {
                this.integrationComponents.add(component);
            }
        }
        return this._this();
    }

    B currentComponent(Object component) {
        this.currentComponent = component;
        return this._this();
    }

    public B fixedSubscriberChannel() {
        return this.fixedSubscriberChannel(null);
    }

    public B fixedSubscriberChannel(String messageChannelName) {
        return this.channel(new FixedSubscriberChannelPrototype(messageChannelName));
    }

    public B channel(String messageChannelName) {
        return this.channel(new MessageChannelReference(messageChannelName));
    }

    public B channel(Function<Channels, MessageChannelSpec<?, ?>> channels) {
        Assert.notNull(channels);
        return this.channel(channels.apply(new Channels()));
    }

    public B channel(MessageChannelSpec<?, ?> messageChannelSpec) {
        Assert.notNull(messageChannelSpec);
        return this.channel((MessageChannel)messageChannelSpec.get());
    }

    public B channel(MessageChannel messageChannel) {
        Assert.notNull((Object)messageChannel);
        if (this.currentMessageChannel != null) {
            this.register(new GenericEndpointSpec<BridgeHandler>(new BridgeHandler()), null);
        }
        this.currentMessageChannel = messageChannel;
        return this.registerOutputChannelIfCan(this.currentMessageChannel);
    }

    public B publishSubscribeChannel(Consumer<PublishSubscribeSpec> publishSubscribeChannelConfigurer) {
        return this.publishSubscribeChannel(null, publishSubscribeChannelConfigurer);
    }

    public B publishSubscribeChannel(Executor executor, Consumer<PublishSubscribeSpec> publishSubscribeChannelConfigurer) {
        Assert.notNull(publishSubscribeChannelConfigurer);
        PublishSubscribeSpec spec = new PublishSubscribeSpec(executor);
        publishSubscribeChannelConfigurer.accept(spec);
        return ((IntegrationFlowDefinition)this.addComponents(spec.getComponentsToRegister())).channel(spec);
    }

    public B controlBus() {
        return this.controlBus(null);
    }

    public B controlBus(Consumer<GenericEndpointSpec<ServiceActivatingHandler>> endpointConfigurer) {
        return this.handle(new ServiceActivatingHandler((MessageProcessor)new ExpressionCommandMessageProcessor((MethodFilter)new ControlBusMethodFilter())), endpointConfigurer);
    }

    public B transform(String expression) {
        Assert.hasText((String)expression);
        return this.transform((GenericTransformer)new ExpressionEvaluatingTransformer(PARSER.parseExpression(expression)));
    }

    public <S, T> B transform(GenericTransformer<S, T> genericTransformer) {
        return this.transform(null, genericTransformer);
    }

    public <P, T> B transform(Class<P> payloadType, GenericTransformer<P, T> genericTransformer) {
        return this.transform(payloadType, genericTransformer, null);
    }

    public <S, T> B transform(GenericTransformer<S, T> genericTransformer, Consumer<GenericEndpointSpec<MessageTransformingHandler>> endpointConfigurer) {
        return this.transform(null, genericTransformer, endpointConfigurer);
    }

    public <P, T> B transform(Class<P> payloadType, GenericTransformer<P, T> genericTransformer, Consumer<GenericEndpointSpec<MessageTransformingHandler>> endpointConfigurer) {
        Assert.notNull(genericTransformer);
        Transformer transformer = genericTransformer instanceof Transformer ? (Transformer)genericTransformer : (IntegrationFlowDefinition.isLambda(genericTransformer) ? new MethodInvokingTransformer((Object)new LambdaMessageProcessor(genericTransformer, payloadType)) : new MethodInvokingTransformer(genericTransformer));
        return ((IntegrationFlowDefinition)this.addComponent(transformer)).handle((MessageTransformingHandler)new MessageTransformingHandler(transformer), endpointConfigurer);
    }

    public B filter(String expression) {
        return this.filter(expression, null);
    }

    public B filter(String expression, Consumer<FilterEndpointSpec> endpointConfigurer) {
        Assert.hasText((String)expression);
        return this.filter((GenericSelector)new ExpressionEvaluatingSelector(expression), endpointConfigurer);
    }

    public <P> B filter(GenericSelector<P> genericSelector) {
        return this.filter(null, genericSelector);
    }

    public <P> B filter(Class<P> payloadType, GenericSelector<P> genericSelector) {
        return this.filter(payloadType, genericSelector, null);
    }

    public <P> B filter(GenericSelector<P> genericSelector, Consumer<FilterEndpointSpec> endpointConfigurer) {
        return this.filter(null, genericSelector, endpointConfigurer);
    }

    public <P> B filter(Class<P> payloadType, GenericSelector<P> genericSelector, Consumer<FilterEndpointSpec> endpointConfigurer) {
        Assert.notNull(genericSelector);
        MessageSelector selector = genericSelector instanceof MessageSelector ? (MessageSelector)genericSelector : (IntegrationFlowDefinition.isLambda(genericSelector) ? new MethodInvokingSelector((Object)new LambdaMessageProcessor(genericSelector, payloadType)) : new MethodInvokingSelector(genericSelector));
        return this.register(new FilterEndpointSpec(new MessageFilter(selector)), endpointConfigurer);
    }

    public <H extends MessageHandler> B handleWithAdapter(Function<Adapters, MessageHandlerSpec<?, H>> adapters) {
        return this.handleWithAdapter(adapters, null);
    }

    public <H extends MessageHandler> B handleWithAdapter(Function<Adapters, MessageHandlerSpec<?, H>> adapters, Consumer<GenericEndpointSpec<H>> endpointConfigurer) {
        return this.handle((H)adapters.apply(new Adapters()), endpointConfigurer);
    }

    public B handle(MessageHandlerSpec<?, ? extends MessageHandler> messageHandlerSpec) {
        return this.handle((MessageHandler)messageHandlerSpec, null);
    }

    public B handle(MessageHandler messageHandler) {
        return this.handle(messageHandler, null);
    }

    public B handle(String beanName, String methodName) {
        return this.handle(beanName, methodName, null);
    }

    public B handle(String beanName, String methodName, Consumer<GenericEndpointSpec<ServiceActivatingHandler>> endpointConfigurer) {
        return this.handle(new ServiceActivatingHandler(new BeanNameMessageProcessor(beanName, methodName)), endpointConfigurer);
    }

    public <P> B handle(GenericHandler<P> handler) {
        return this.handle(null, handler);
    }

    public <P> B handle(GenericHandler<P> handler, Consumer<GenericEndpointSpec<ServiceActivatingHandler>> endpointConfigurer) {
        return this.handle(null, handler, endpointConfigurer);
    }

    public <P> B handle(Class<P> payloadType, GenericHandler<P> handler) {
        return this.handle(payloadType, handler, null);
    }

    public <P> B handle(Class<P> payloadType, GenericHandler<P> handler, Consumer<GenericEndpointSpec<ServiceActivatingHandler>> endpointConfigurer) {
        ServiceActivatingHandler serviceActivatingHandler = null;
        serviceActivatingHandler = IntegrationFlowDefinition.isLambda(handler) ? new ServiceActivatingHandler((MessageProcessor)new LambdaMessageProcessor(handler, payloadType)) : new ServiceActivatingHandler(handler);
        return this.handle(serviceActivatingHandler, endpointConfigurer);
    }

    public <H extends MessageHandler> B handle(MessageHandlerSpec<?, H> messageHandlerSpec, Consumer<GenericEndpointSpec<H>> endpointConfigurer) {
        Assert.notNull(messageHandlerSpec);
        if (messageHandlerSpec instanceof ComponentsRegistration) {
            this.addComponents(((ComponentsRegistration)((Object)messageHandlerSpec)).getComponentsToRegister());
        }
        return this.handle((MessageHandler)messageHandlerSpec.get(), endpointConfigurer);
    }

    public <H extends MessageHandler> B handle(H messageHandler, Consumer<GenericEndpointSpec<H>> endpointConfigurer) {
        Assert.notNull(messageHandler);
        return this.register(new GenericEndpointSpec<H>(messageHandler), endpointConfigurer);
    }

    public B bridge(Consumer<GenericEndpointSpec<BridgeHandler>> endpointConfigurer) {
        return this.register(new GenericEndpointSpec<BridgeHandler>(new BridgeHandler()), endpointConfigurer);
    }

    public B delay(String groupId) {
        return this.delay(groupId, (String)null);
    }

    public B delay(String groupId, Consumer<DelayerEndpointSpec> endpointConfigurer) {
        return this.delay(groupId, (String)null, endpointConfigurer);
    }

    public B delay(String groupId, String expression) {
        return this.delay(groupId, expression, null);
    }

    public <P> B delay(String groupId, Function<Message<P>, Object> function) {
        return this.delay(groupId, function, null);
    }

    public <P> B delay(String groupId, Function<Message<P>, Object> function, Consumer<DelayerEndpointSpec> endpointConfigurer) {
        Assert.notNull(function);
        return this.delay(groupId, new FunctionExpression<Message<P>>(function), endpointConfigurer);
    }

    public B delay(String groupId, String expression, Consumer<DelayerEndpointSpec> endpointConfigurer) {
        return this.delay(groupId, StringUtils.hasText((String)expression) ? PARSER.parseExpression(expression) : null, endpointConfigurer);
    }

    private B delay(String groupId, Expression expression, Consumer<DelayerEndpointSpec> endpointConfigurer) {
        DelayHandler delayHandler = new DelayHandler(groupId);
        if (expression != null) {
            delayHandler.setDelayExpression(expression);
        }
        return this.register(new DelayerEndpointSpec(delayHandler), endpointConfigurer);
    }

    public B enrich(Consumer<EnricherSpec> enricherConfigurer) {
        return this.enrich(enricherConfigurer, null);
    }

    public B enrich(Consumer<EnricherSpec> enricherConfigurer, Consumer<GenericEndpointSpec<ContentEnricher>> endpointConfigurer) {
        Assert.notNull(enricherConfigurer);
        EnricherSpec enricherSpec = new EnricherSpec();
        enricherConfigurer.accept(enricherSpec);
        return this.handle((MessageHandler)enricherSpec.get(), endpointConfigurer);
    }

    public B enrichHeaders(MapBuilder<?, String, Object> headers) {
        return this.enrichHeaders(headers, null);
    }

    public B enrichHeaders(MapBuilder<?, String, Object> headers, Consumer<GenericEndpointSpec<MessageTransformingHandler>> endpointConfigurer) {
        return this.enrichHeaders(headers.get(), endpointConfigurer);
    }

    public B enrichHeaders(Map<String, Object> headers) {
        return this.enrichHeaders(headers, null);
    }

    public B enrichHeaders(final Map<String, Object> headers, Consumer<GenericEndpointSpec<MessageTransformingHandler>> endpointConfigurer) {
        return this.enrichHeaders(new Consumer<HeaderEnricherSpec>(){

            @Override
            public void accept(HeaderEnricherSpec spec) {
                spec.headers(headers);
            }
        }, endpointConfigurer);
    }

    public B enrichHeaders(Consumer<HeaderEnricherSpec> headerEnricherConfigurer) {
        return this.enrichHeaders(headerEnricherConfigurer, null);
    }

    public B enrichHeaders(Consumer<HeaderEnricherSpec> headerEnricherConfigurer, Consumer<GenericEndpointSpec<MessageTransformingHandler>> endpointConfigurer) {
        Assert.notNull(headerEnricherConfigurer);
        HeaderEnricherSpec headerEnricherSpec = new HeaderEnricherSpec();
        headerEnricherConfigurer.accept(headerEnricherSpec);
        return this.transform((GenericTransformer)headerEnricherSpec.get(), endpointConfigurer);
    }

    public B split() {
        return this.split(null);
    }

    public B split(Consumer<SplitterEndpointSpec<DefaultMessageSplitter>> endpointConfigurer) {
        return this.split(new DefaultMessageSplitter(), endpointConfigurer);
    }

    public B split(String expression, Consumer<SplitterEndpointSpec<ExpressionEvaluatingSplitter>> endpointConfigurer) {
        return this.split(new ExpressionEvaluatingSplitter(PARSER.parseExpression(expression)), endpointConfigurer);
    }

    public B split(String beanName, String methodName) {
        return this.split(beanName, methodName, null);
    }

    public B split(String beanName, String methodName, Consumer<SplitterEndpointSpec<MethodInvokingSplitter>> endpointConfigurer) {
        return this.split(new MethodInvokingSplitter(new BeanNameMessageProcessor(beanName, methodName)), endpointConfigurer);
    }

    public <P> B split(Class<P> payloadType, Function<P, ?> splitter) {
        return this.split(payloadType, splitter, null);
    }

    public <P> B split(Function<P, ?> splitter, Consumer<SplitterEndpointSpec<MethodInvokingSplitter>> endpointConfigurer) {
        return this.split(null, splitter, endpointConfigurer);
    }

    public <P> B split(Class<P> payloadType, Function<P, ?> splitter, Consumer<SplitterEndpointSpec<MethodInvokingSplitter>> endpointConfigurer) {
        MethodInvokingSplitter split = IntegrationFlowDefinition.isLambda(splitter) ? new MethodInvokingSplitter((Object)new LambdaMessageProcessor(splitter, payloadType)) : new MethodInvokingSplitter(splitter);
        return this.split(split, endpointConfigurer);
    }

    public <S extends AbstractMessageSplitter> B split(S splitter, Consumer<SplitterEndpointSpec<S>> endpointConfigurer) {
        Assert.notNull(splitter);
        return this.register(new SplitterEndpointSpec<S>(splitter), endpointConfigurer);
    }

    public B headerFilter(String ... headersToRemove) {
        return this.headerFilter(new HeaderFilter(headersToRemove), null);
    }

    public B headerFilter(String headersToRemove, boolean patternMatch) {
        HeaderFilter headerFilter = new HeaderFilter(StringUtils.delimitedListToStringArray((String)headersToRemove, (String)",", (String)" "));
        headerFilter.setPatternMatch(patternMatch);
        return this.headerFilter(headerFilter, null);
    }

    public B headerFilter(HeaderFilter headerFilter, Consumer<GenericEndpointSpec<MessageTransformingHandler>> endpointConfigurer) {
        return this.transform((GenericTransformer)headerFilter, endpointConfigurer);
    }

    public B claimCheckIn(MessageStore messageStore) {
        return this.claimCheckIn(messageStore, null);
    }

    public B claimCheckIn(MessageStore messageStore, Consumer<GenericEndpointSpec<MessageTransformingHandler>> endpointConfigurer) {
        return this.transform((GenericTransformer)new ClaimCheckInTransformer(messageStore), endpointConfigurer);
    }

    public B claimCheckOut(MessageStore messageStore) {
        return this.claimCheckOut(messageStore, false);
    }

    public B claimCheckOut(MessageStore messageStore, boolean removeMessage) {
        return this.claimCheckOut(messageStore, removeMessage, null);
    }

    public B claimCheckOut(MessageStore messageStore, boolean removeMessage, Consumer<GenericEndpointSpec<MessageTransformingHandler>> endpointConfigurer) {
        ClaimCheckOutTransformer claimCheckOutTransformer = new ClaimCheckOutTransformer(messageStore);
        claimCheckOutTransformer.setRemoveMessage(removeMessage);
        return this.transform((GenericTransformer)claimCheckOutTransformer, endpointConfigurer);
    }

    public B resequence() {
        return this.resequence(null);
    }

    public B resequence(Consumer<GenericEndpointSpec<ResequencingMessageHandler>> endpointConfigurer) {
        return this.handle((MessageHandler)new ResequencerSpec().get(), endpointConfigurer);
    }

    public B resequence(Consumer<ResequencerSpec> resequencerConfigurer, Consumer<GenericEndpointSpec<ResequencingMessageHandler>> endpointConfigurer) {
        Assert.notNull(resequencerConfigurer);
        ResequencerSpec spec = new ResequencerSpec();
        resequencerConfigurer.accept(spec);
        return this.handle((MessageHandler)spec.get(), endpointConfigurer);
    }

    public B aggregate() {
        return this.aggregate(null);
    }

    public B aggregate(Consumer<GenericEndpointSpec<AggregatingMessageHandler>> endpointConfigurer) {
        return this.handle((MessageHandler)new AggregatorSpec().get(), endpointConfigurer);
    }

    public B aggregate(Consumer<AggregatorSpec> aggregatorConfigurer, Consumer<GenericEndpointSpec<AggregatingMessageHandler>> endpointConfigurer) {
        Assert.notNull(aggregatorConfigurer);
        AggregatorSpec spec = new AggregatorSpec();
        aggregatorConfigurer.accept(spec);
        return this.handle((MessageHandler)spec.get(), endpointConfigurer);
    }

    public B route(String beanName, String method) {
        return this.route(beanName, method, null);
    }

    public B route(String beanName, String method, Consumer<RouterSpec<MethodInvokingRouter>> routerConfigurer) {
        return this.route(beanName, method, routerConfigurer, null);
    }

    public B route(String beanName, String method, Consumer<RouterSpec<MethodInvokingRouter>> routerConfigurer, Consumer<GenericEndpointSpec<MethodInvokingRouter>> endpointConfigurer) {
        return this.route(new MethodInvokingRouter(new BeanNameMessageProcessor(beanName, method)), routerConfigurer, endpointConfigurer);
    }

    public B route(String expression) {
        return this.route((AbstractMessageRouter)expression, (Consumer)null);
    }

    public B route(String expression, Consumer<RouterSpec<ExpressionEvaluatingRouter>> routerConfigurer) {
        return this.route((AbstractMappingMessageRouter)expression, routerConfigurer, null);
    }

    public B route(String expression, Consumer<RouterSpec<ExpressionEvaluatingRouter>> routerConfigurer, Consumer<GenericEndpointSpec<ExpressionEvaluatingRouter>> endpointConfigurer) {
        return this.route(new ExpressionEvaluatingRouter(PARSER.parseExpression(expression)), routerConfigurer, endpointConfigurer);
    }

    public <S, T> B route(Function<S, T> router) {
        return this.route(null, router);
    }

    public <S, T> B route(Function<S, T> router, Consumer<RouterSpec<MethodInvokingRouter>> routerConfigurer) {
        return this.route(null, router, routerConfigurer);
    }

    public <P, T> B route(Class<P> payloadType, Function<P, T> router) {
        return this.route(payloadType, router, null, null);
    }

    public <P, T> B route(Class<P> payloadType, Function<P, T> router, Consumer<RouterSpec<MethodInvokingRouter>> routerConfigurer) {
        return this.route(payloadType, router, routerConfigurer, null);
    }

    public <S, T> B route(Function<S, T> router, Consumer<RouterSpec<MethodInvokingRouter>> routerConfigurer, Consumer<GenericEndpointSpec<MethodInvokingRouter>> endpointConfigurer) {
        return this.route(null, router, routerConfigurer, endpointConfigurer);
    }

    public <P, T> B route(Class<P> payloadType, Function<P, T> router, Consumer<RouterSpec<MethodInvokingRouter>> routerConfigurer, Consumer<GenericEndpointSpec<MethodInvokingRouter>> endpointConfigurer) {
        MethodInvokingRouter methodInvokingRouter = IntegrationFlowDefinition.isLambda(router) ? new MethodInvokingRouter((Object)new LambdaMessageProcessor(router, payloadType)) : new MethodInvokingRouter(router);
        return this.route(methodInvokingRouter, routerConfigurer, endpointConfigurer);
    }

    public <R extends AbstractMappingMessageRouter> B route(R router, Consumer<RouterSpec<R>> routerConfigurer, Consumer<GenericEndpointSpec<R>> endpointConfigurer) {
        Collection<Object> componentsToRegister = null;
        if (routerConfigurer != null) {
            RouterSpec<R> routerSpec = new RouterSpec<R>(router);
            routerConfigurer.accept(routerSpec);
            componentsToRegister = routerSpec.getComponentsToRegister();
        }
        this.route(router, endpointConfigurer);
        DirectChannel afterRouterChannel = new DirectChannel();
        boolean hasSubFlows = false;
        if (!CollectionUtils.isEmpty(componentsToRegister)) {
            for (Object component : componentsToRegister) {
                if (component instanceof IntegrationFlowDefinition) {
                    hasSubFlows = true;
                    IntegrationFlowDefinition flowBuilder = (IntegrationFlowDefinition)component;
                    this.addComponent(((IntegrationFlowDefinition)((IntegrationFlowDefinition)flowBuilder.fixedSubscriberChannel()).bridge(new Consumer<GenericEndpointSpec<BridgeHandler>>((MessageChannel)afterRouterChannel){
                        final /* synthetic */ MessageChannel val$afterRouterChannel;
                        {
                            this.val$afterRouterChannel = messageChannel;
                        }

                        @Override
                        public void accept(GenericEndpointSpec<BridgeHandler> bridge) {
                            ((BridgeHandler)((Tuple2)bridge.get()).getT2()).setOutputChannel(this.val$afterRouterChannel);
                        }
                    })).get());
                    continue;
                }
                this.addComponent(component);
            }
        }
        if (hasSubFlows) {
            this.channel((MessageChannel)afterRouterChannel);
        }
        return this._this();
    }

    public B routeToRecipients(Consumer<RecipientListRouterSpec> routerConfigurer) {
        return this.routeToRecipients(routerConfigurer, null);
    }

    public B routeToRecipients(Consumer<RecipientListRouterSpec> routerConfigurer, Consumer<GenericEndpointSpec<RecipientListRouter>> endpointConfigurer) {
        Assert.notNull(routerConfigurer);
        RecipientListRouterSpec spec = new RecipientListRouterSpec();
        routerConfigurer.accept(spec);
        this.addComponents(spec.getComponentsToRegister());
        return this.route((AbstractMessageRouter)spec.get(), endpointConfigurer);
    }

    public B route(AbstractMessageRouter router) {
        return this.route(router, null);
    }

    public <R extends AbstractMessageRouter> B route(R router, Consumer<GenericEndpointSpec<R>> endpointConfigurer) {
        return this.handle((MessageHandler)router, endpointConfigurer);
    }

    public B gateway(String requestChannel) {
        return this.gateway(requestChannel, null);
    }

    public B gateway(String requestChannel, Consumer<GatewayEndpointSpec> endpointConfigurer) {
        return this.register(new GatewayEndpointSpec(requestChannel), endpointConfigurer);
    }

    public B gateway(MessageChannel requestChannel) {
        return this.gateway(requestChannel, null);
    }

    public B gateway(MessageChannel requestChannel, Consumer<GatewayEndpointSpec> endpointConfigurer) {
        return this.register(new GatewayEndpointSpec(requestChannel), endpointConfigurer);
    }

    public B gateway(IntegrationFlow flow) {
        return this.gateway(flow, null);
    }

    public B gateway(IntegrationFlow flow, Consumer<GatewayEndpointSpec> endpointConfigurer) {
        Assert.notNull((Object)flow);
        DirectChannel requestChannel = new DirectChannel();
        IntegrationFlowBuilder flowBuilder = IntegrationFlows.from((MessageChannel)requestChannel);
        flow.accept(flowBuilder);
        this.addComponent(flowBuilder.get());
        return this.gateway((MessageChannel)requestChannel, endpointConfigurer);
    }

    private <S extends ConsumerEndpointSpec<S, ?>> B register(S endpointSpec, Consumer<S> endpointConfigurer) {
        if (endpointConfigurer != null) {
            endpointConfigurer.accept(endpointSpec);
        }
        if (endpointSpec instanceof ComponentsRegistration) {
            this.addComponents(((ComponentsRegistration)((Object)endpointSpec)).getComponentsToRegister());
        }
        MessageChannel inputChannel = this.currentMessageChannel;
        this.currentMessageChannel = null;
        if (inputChannel == null) {
            inputChannel = new DirectChannel();
            this.registerOutputChannelIfCan(inputChannel);
        }
        if (inputChannel instanceof MessageChannelReference) {
            ((ConsumerEndpointFactoryBean)((Tuple2)endpointSpec.get()).getT1()).setInputChannelName(((MessageChannelReference)inputChannel).getName());
        } else {
            if (inputChannel instanceof FixedSubscriberChannelPrototype) {
                String beanName = ((FixedSubscriberChannelPrototype)inputChannel).getName();
                inputChannel = new FixedSubscriberChannel((MessageHandler)((Tuple2)endpointSpec.get()).getT2());
                if (beanName != null) {
                    ((FixedSubscriberChannel)inputChannel).setBeanName(beanName);
                }
                this.registerOutputChannelIfCan(inputChannel);
            }
            ((ConsumerEndpointFactoryBean)((Tuple2)endpointSpec.get()).getT1()).setInputChannel(inputChannel);
        }
        return ((IntegrationFlowDefinition)this.addComponent(endpointSpec)).currentComponent(((Tuple2)endpointSpec.get()).getT2());
    }

    private B registerOutputChannelIfCan(MessageChannel outputChannel) {
        if (!(outputChannel instanceof FixedSubscriberChannelPrototype)) {
            this.integrationComponents.add(outputChannel);
            if (this.currentComponent != null) {
                Object currentComponent;
                String channelName = null;
                if (outputChannel instanceof MessageChannelReference) {
                    channelName = ((MessageChannelReference)outputChannel).getName();
                }
                if (AopUtils.isAopProxy((Object)(currentComponent = this.currentComponent))) {
                    currentComponent = IntegrationFlowDefinition.extractProxyTarget(currentComponent);
                }
                if (currentComponent instanceof AbstractReplyProducingMessageHandler) {
                    AbstractReplyProducingMessageHandler messageProducer = (AbstractReplyProducingMessageHandler)currentComponent;
                    if (channelName != null) {
                        messageProducer.setOutputChannelName(channelName);
                    } else {
                        messageProducer.setOutputChannel(outputChannel);
                    }
                } else if (currentComponent instanceof SourcePollingChannelAdapterSpec) {
                    SourcePollingChannelAdapterFactoryBean pollingChannelAdapterFactoryBean = (SourcePollingChannelAdapterFactoryBean)((Tuple2)((SourcePollingChannelAdapterSpec)currentComponent).get()).getT1();
                    if (channelName != null) {
                        pollingChannelAdapterFactoryBean.setOutputChannelName(channelName);
                    } else {
                        pollingChannelAdapterFactoryBean.setOutputChannel(outputChannel);
                    }
                } else if (currentComponent instanceof AbstractCorrelatingMessageHandler) {
                    AbstractCorrelatingMessageHandler messageProducer = (AbstractCorrelatingMessageHandler)currentComponent;
                    if (channelName != null) {
                        messageProducer.setOutputChannelName(channelName);
                    } else {
                        messageProducer.setOutputChannel(outputChannel);
                    }
                } else if (this.currentComponent instanceof AbstractMessageRouter) {
                    AbstractMessageRouter router = (AbstractMessageRouter)this.currentComponent;
                    if (channelName != null) {
                        router.setDefaultOutputChannelName(channelName);
                    } else {
                        router.setDefaultOutputChannel(outputChannel);
                    }
                } else {
                    throw new BeanCreationException("The 'currentComponent' (" + currentComponent + ") is a one-way 'MessageHandler' and it isn't appropriate to configure 'outputChannel'. " + "This is the end of the integration flow.");
                }
                this.currentComponent = null;
            }
        }
        return this._this();
    }

    protected final B _this() {
        return (B)this;
    }

    private static boolean isLambda(Object o) {
        Class<?> aClass = o.getClass();
        return aClass.isSynthetic() && !aClass.isAnonymousClass() && !aClass.isLocalClass();
    }

    private static Object extractProxyTarget(Object target) {
        if (!(target instanceof Advised)) {
            return target;
        }
        Advised advised = (Advised)target;
        if (advised.getTargetSource() == null) {
            return null;
        }
        try {
            return IntegrationFlowDefinition.extractProxyTarget(advised.getTargetSource().getTarget());
        }
        catch (Exception e) {
            throw new BeanCreationException("Could not extract target", (Throwable)e);
        }
    }

    protected StandardIntegrationFlow get() {
        if (this.currentMessageChannel instanceof FixedSubscriberChannelPrototype) {
            throw new BeanCreationException("The 'currentMessageChannel' (" + this.currentMessageChannel + ") is a prototype for FixedSubscriberChannel which can't be created without MessageHandler " + "constructor argument. That means that '.fixedSubscriberChannel()' can't be the last EIP-method " + "in the IntegrationFlow definition.");
        }
        if (this.integrationComponents.size() == 1) {
            if (this.currentComponent != null) {
                if (this.currentComponent instanceof SourcePollingChannelAdapterSpec) {
                    throw new BeanCreationException("The 'SourcePollingChannelAdapter' (" + this.currentComponent + ") " + "must be configured with at least one 'MessageChanel' or 'MessageHandler'.");
                }
            } else if (this.currentMessageChannel != null) {
                throw new BeanCreationException("The 'IntegrationFlow' can't consist of only one 'MessageChannel'. Add at lest '.bridge()' EIP-method before the end of flow.");
            }
        }
        return new StandardIntegrationFlow(this.integrationComponents);
    }
}

