/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.amqp;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.integration.amqp.outbound.AmqpOutboundEndpoint;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.dsl.core.MessageHandlerSpec;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class AmqpOutboundEndpointSpec
extends MessageHandlerSpec<AmqpOutboundEndpointSpec, AmqpOutboundEndpoint> {
    private final AmqpOutboundEndpoint endpoint;
    private final boolean expectReply;
    private final DefaultAmqpHeaderMapper headerMapper = new DefaultAmqpHeaderMapper();

    AmqpOutboundEndpointSpec(AmqpTemplate amqpTemplate, boolean expectReply) {
        this.endpoint = new AmqpOutboundEndpoint(amqpTemplate);
        this.expectReply = expectReply;
        this.endpoint.setExpectReply(expectReply);
        this.endpoint.setHeaderMapper((AmqpHeaderMapper)this.headerMapper);
        if (expectReply) {
            this.endpoint.setRequiresReply(true);
        }
    }

    public AmqpOutboundEndpointSpec headerMapper(AmqpHeaderMapper headerMapper) {
        this.endpoint.setHeaderMapper(headerMapper);
        return this;
    }

    public AmqpOutboundEndpointSpec routingKey(String routingKey) {
        this.endpoint.setRoutingKey(routingKey);
        return this;
    }

    public AmqpOutboundEndpointSpec defaultDeliveryMode(MessageDeliveryMode defaultDeliveryMode) {
        this.endpoint.setDefaultDeliveryMode(defaultDeliveryMode);
        return this;
    }

    public AmqpOutboundEndpointSpec exchangeName(String exchangeName) {
        this.endpoint.setExchangeName(exchangeName);
        return this;
    }

    public AmqpOutboundEndpointSpec routingKeyExpression(String routingKeyExpression) {
        this.endpoint.setRoutingKeyExpression(routingKeyExpression);
        return this;
    }

    public AmqpOutboundEndpointSpec returnChannel(MessageChannel returnChannel) {
        this.endpoint.setReturnChannel(returnChannel);
        return this;
    }

    public AmqpOutboundEndpointSpec confirmAckChannel(MessageChannel ackChannel) {
        this.endpoint.setConfirmAckChannel(ackChannel);
        return this;
    }

    public AmqpOutboundEndpointSpec exchangeNameExpression(String exchangeNameExpression) {
        this.endpoint.setExchangeNameExpression(exchangeNameExpression);
        return this;
    }

    public AmqpOutboundEndpointSpec confirmNackChannel(MessageChannel nackChannel) {
        this.endpoint.setConfirmNackChannel(nackChannel);
        return this;
    }

    public AmqpOutboundEndpointSpec confirmCorrelationExpression(String confirmCorrelationExpression) {
        this.endpoint.setConfirmCorrelationExpression(confirmCorrelationExpression);
        return this;
    }

    public AmqpOutboundEndpointSpec mappedRequestHeaders(String ... headers) {
        this.headerMapper.setRequestHeaderNames(headers);
        return this;
    }

    public AmqpOutboundEndpointSpec mappedReplyHeaders(String ... headers) {
        Assert.isTrue((boolean)this.expectReply, (String)"'mappedReplyHeaders' can be applied only for gateway");
        this.headerMapper.setReplyHeaderNames(headers);
        return this;
    }

    @Override
    protected AmqpOutboundEndpoint doGet() {
        return this.endpoint;
    }
}

