/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.file;

import java.io.File;
import java.util.Comparator;
import org.springframework.integration.dsl.core.MessageSourceSpec;
import org.springframework.integration.file.DirectoryScanner;
import org.springframework.integration.file.FileLocker;
import org.springframework.integration.file.FileReadingMessageSource;
import org.springframework.integration.file.filters.AcceptAllFileListFilter;
import org.springframework.integration.file.filters.AcceptOnceFileListFilter;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.filters.RegexPatternFileListFilter;
import org.springframework.integration.file.filters.SimplePatternFileListFilter;
import org.springframework.integration.file.locking.NioFileLocker;
import org.springframework.util.Assert;

public class FileInboundChannelAdapterSpec
extends MessageSourceSpec<FileInboundChannelAdapterSpec, FileReadingMessageSource> {
    private FileListFilter<File> filter;
    private FileLocker locker;

    FileInboundChannelAdapterSpec() {
        this.target = new FileReadingMessageSource();
    }

    FileInboundChannelAdapterSpec(Comparator<File> receptionOrderComparator) {
        this.target = new FileReadingMessageSource(receptionOrderComparator);
    }

    FileInboundChannelAdapterSpec directory(File directory) {
        ((FileReadingMessageSource)this.target).setDirectory(directory);
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec scanner(DirectoryScanner scanner) {
        ((FileReadingMessageSource)this.target).setScanner(scanner);
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec autoCreateDirectory(boolean autoCreateDirectory) {
        ((FileReadingMessageSource)this.target).setAutoCreateDirectory(autoCreateDirectory);
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec filter(FileListFilter<File> filter) {
        return this.filter(filter, false);
    }

    public FileInboundChannelAdapterSpec filter(FileListFilter<File> filter, boolean preventDuplicates) {
        Assert.isNull(this.filter, (String)("The 'filter' (" + this.filter + ") is already configured for the FileReadingMessageSource"));
        FileListFilter<File> targetFilter = filter;
        if (preventDuplicates) {
            targetFilter = this.createCompositeWithAcceptOnceFilter(filter);
        }
        this.filter = targetFilter;
        ((FileReadingMessageSource)this.target).setFilter(targetFilter);
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec preventDuplicatesFilter(boolean preventDuplicates) {
        if (preventDuplicates) {
            return this.filter((FileListFilter<File>)new AcceptOnceFileListFilter(), false);
        }
        return this.filter((FileListFilter<File>)new AcceptAllFileListFilter(), false);
    }

    public FileInboundChannelAdapterSpec patternFilter(String pattern) {
        return this.patternFilter(pattern, true);
    }

    public FileInboundChannelAdapterSpec patternFilter(String pattern, boolean preventDuplicates) {
        return this.filter((FileListFilter<File>)new SimplePatternFileListFilter(pattern), preventDuplicates);
    }

    public FileInboundChannelAdapterSpec regexFilter(String regex) {
        return this.regexFilter(regex, true);
    }

    public FileInboundChannelAdapterSpec regexFilter(String regex, boolean preventDuplicates) {
        return this.filter((FileListFilter<File>)new RegexPatternFileListFilter(regex), preventDuplicates);
    }

    private CompositeFileListFilter<File> createCompositeWithAcceptOnceFilter(FileListFilter<File> otherFilter) {
        CompositeFileListFilter compositeFilter = new CompositeFileListFilter();
        compositeFilter.addFilter((FileListFilter)new AcceptOnceFileListFilter());
        compositeFilter.addFilter(otherFilter);
        return compositeFilter;
    }

    public FileInboundChannelAdapterSpec locker(FileLocker locker) {
        Assert.isNull((Object)this.locker, (String)("The 'locker' (" + this.locker + ") is already configured for the FileReadingMessageSource"));
        this.locker = locker;
        ((FileReadingMessageSource)this.target).setLocker(locker);
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec nioLocker() {
        return this.locker((FileLocker)new NioFileLocker());
    }

    public FileInboundChannelAdapterSpec scanEachPoll(boolean scanEachPoll) {
        ((FileReadingMessageSource)this.target).setScanEachPoll(scanEachPoll);
        return (FileInboundChannelAdapterSpec)this._this();
    }

    @Override
    protected FileReadingMessageSource doGet() {
        throw new UnsupportedOperationException();
    }
}

