/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.jms;

import java.util.concurrent.Executor;
import javax.jms.ConnectionFactory;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.integration.dsl.jms.JmsPollableMessageChannelSpec;
import org.springframework.integration.jms.AbstractJmsChannel;
import org.springframework.integration.jms.config.JmsChannelFactoryBean;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ErrorHandler;

public class JmsMessageChannelSpec<S extends JmsMessageChannelSpec<S>>
extends JmsPollableMessageChannelSpec<S> {
    private Integer cacheLevel;

    JmsMessageChannelSpec(ConnectionFactory connectionFactory) {
        super(new JmsChannelFactoryBean(true), connectionFactory);
    }

    public S containerType(Class<? extends AbstractMessageListenerContainer> containerType) {
        this.jmsChannelFactoryBean.setContainerType(containerType);
        return (S)((JmsMessageChannelSpec)this._this());
    }

    public S concurrentConsumers(int concurrentConsumers) {
        this.jmsChannelFactoryBean.setConcurrentConsumers(concurrentConsumers);
        return (S)((JmsMessageChannelSpec)this._this());
    }

    public S maxSubscribers(int maxSubscribers) {
        this.jmsChannelFactoryBean.setMaxSubscribers(maxSubscribers);
        return (S)((JmsMessageChannelSpec)this._this());
    }

    public S autoStartup(boolean autoStartup) {
        this.jmsChannelFactoryBean.setAutoStartup(autoStartup);
        return (S)((JmsMessageChannelSpec)this._this());
    }

    public S phase(int phase) {
        this.jmsChannelFactoryBean.setPhase(phase);
        return (S)((JmsMessageChannelSpec)this._this());
    }

    public S errorHandler(ErrorHandler errorHandler) {
        this.jmsChannelFactoryBean.setErrorHandler(errorHandler);
        return (S)((JmsMessageChannelSpec)this._this());
    }

    public S exposeListenerSession(boolean exposeListenerSession) {
        this.jmsChannelFactoryBean.setExposeListenerSession(exposeListenerSession);
        return (S)((JmsMessageChannelSpec)this._this());
    }

    public S acceptMessagesWhileStopping(boolean acceptMessagesWhileStopping) {
        this.jmsChannelFactoryBean.setAcceptMessagesWhileStopping(acceptMessagesWhileStopping);
        return (S)((JmsMessageChannelSpec)this._this());
    }

    public S idleTaskExecutionLimit(int idleTaskExecutionLimit) {
        this.jmsChannelFactoryBean.setIdleTaskExecutionLimit(idleTaskExecutionLimit);
        return (S)((JmsMessageChannelSpec)this._this());
    }

    public S maxMessagesPerTask(int maxMessagesPerTask) {
        this.jmsChannelFactoryBean.setMaxMessagesPerTask(maxMessagesPerTask);
        return (S)((JmsMessageChannelSpec)this._this());
    }

    public S recoveryInterval(long recoveryInterval) {
        this.jmsChannelFactoryBean.setRecoveryInterval(recoveryInterval);
        return (S)((JmsMessageChannelSpec)this._this());
    }

    public S taskExecutor(Executor taskExecutor) {
        this.jmsChannelFactoryBean.setTaskExecutor(taskExecutor);
        return (S)((JmsMessageChannelSpec)this._this());
    }

    public S transactionManager(PlatformTransactionManager transactionManager) {
        this.jmsChannelFactoryBean.setTransactionManager(transactionManager);
        return (S)((JmsMessageChannelSpec)this._this());
    }

    public S transactionName(String transactionName) {
        this.jmsChannelFactoryBean.setTransactionName(transactionName);
        return (S)((JmsMessageChannelSpec)this._this());
    }

    public S transactionTimeout(int transactionTimeout) {
        this.jmsChannelFactoryBean.setTransactionTimeout(transactionTimeout);
        return (S)((JmsMessageChannelSpec)this._this());
    }

    public S cacheLevel(Integer cacheLevel) {
        this.cacheLevel = cacheLevel;
        return (S)((JmsMessageChannelSpec)this._this());
    }

    @Override
    protected AbstractJmsChannel doGet() {
        DirectFieldAccessor dfa;
        Object container;
        AbstractJmsChannel jmsChannel = super.doGet();
        if (this.cacheLevel != null && (container = (dfa = new DirectFieldAccessor((Object)jmsChannel)).getPropertyValue("container")) instanceof DefaultMessageListenerContainer) {
            ((DefaultMessageListenerContainer)container).setCacheLevel(this.cacheLevel.intValue());
        }
        return jmsChannel;
    }
}

