/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.mail;

import java.lang.reflect.Constructor;
import java.util.Properties;
import javax.activation.FileTypeMap;
import org.springframework.integration.dsl.core.MessageHandlerSpec;
import org.springframework.integration.dsl.support.Consumer;
import org.springframework.integration.dsl.support.PropertiesBuilder;
import org.springframework.integration.mail.MailSendingMessageHandler;
import org.springframework.mail.MailSender;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.util.ClassUtils;

public class MailSendingMessageHandlerSpec
extends MessageHandlerSpec<MailSendingMessageHandlerSpec, MailSendingMessageHandler> {
    private static final Constructor<?> MAIL_SENDER_CONSTRUCTOR = ClassUtils.getConstructorIfAvailable(MailSendingMessageHandler.class, (Class[])new Class[]{MailSender.class});
    private final JavaMailSenderImpl sender = new JavaMailSenderImpl();

    MailSendingMessageHandlerSpec(String host) {
        this.sender.setHost(host);
        if (MAIL_SENDER_CONSTRUCTOR == null) {
            this.target = new MailSendingMessageHandler((JavaMailSender)this.sender);
        } else {
            try {
                this.target = (MailSendingMessageHandler)MAIL_SENDER_CONSTRUCTOR.newInstance(this.sender);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public MailSendingMessageHandlerSpec javaMailProperties(Properties javaMailProperties) {
        this.sender.setJavaMailProperties(javaMailProperties);
        return this;
    }

    public MailSendingMessageHandlerSpec javaMailProperties(Consumer<PropertiesBuilder> propertiesConfigurer) {
        PropertiesBuilder properties = new PropertiesBuilder();
        propertiesConfigurer.accept(properties);
        return this.javaMailProperties(properties.get());
    }

    public MailSendingMessageHandlerSpec protocol(String protocol) {
        this.sender.setProtocol(protocol);
        return this;
    }

    public MailSendingMessageHandlerSpec port(int port) {
        this.sender.setPort(port);
        return this;
    }

    public MailSendingMessageHandlerSpec credentials(String username, String password) {
        this.sender.setUsername(username);
        this.sender.setPassword(password);
        return this;
    }

    public MailSendingMessageHandlerSpec defaultEncoding(String defaultEncoding) {
        this.sender.setDefaultEncoding(defaultEncoding);
        return this;
    }

    public MailSendingMessageHandlerSpec defaultFileTypeMap(FileTypeMap defaultFileTypeMap) {
        this.sender.setDefaultFileTypeMap(defaultFileTypeMap);
        return this;
    }

    @Override
    protected MailSendingMessageHandler doGet() {
        throw new UnsupportedOperationException();
    }
}

