/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.dsl.AbstractRouterSpec;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.router.AbstractMappingMessageRouter;
import org.springframework.integration.router.MappingMessageRouterManagement;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class RouterSpec<R extends AbstractMappingMessageRouter>
extends AbstractRouterSpec<RouterSpec<R>, R>
implements ComponentsRegistration {
    private final List<Object> subFlows = new ArrayList<Object>();
    private String prefix;
    private String suffix;
    private RouterSubFlowMappingProvider mappingProvider;

    RouterSpec(R router) {
        super(router);
    }

    public RouterSpec<R> resolutionRequired(boolean resolutionRequired) {
        ((AbstractMappingMessageRouter)this.target).setResolutionRequired(resolutionRequired);
        return (RouterSpec)this._this();
    }

    public RouterSpec<R> prefix(String prefix) {
        Assert.state((boolean)this.subFlows.isEmpty(), (String)"The 'prefix'('suffix') and 'subFlowMapping' are mutually exclusive");
        this.prefix = prefix;
        ((AbstractMappingMessageRouter)this.target).setPrefix(prefix);
        return (RouterSpec)this._this();
    }

    public RouterSpec<R> suffix(String suffix) {
        Assert.state((boolean)this.subFlows.isEmpty(), (String)"The 'prefix'('suffix') and 'subFlowMapping' are mutually exclusive");
        this.suffix = suffix;
        ((AbstractMappingMessageRouter)this.target).setSuffix(suffix);
        return (RouterSpec)this._this();
    }

    public RouterSpec<R> channelMapping(String key, String channelName) {
        Assert.hasText((String)key);
        Assert.hasText((String)channelName);
        ((AbstractMappingMessageRouter)this.target).setChannelMapping(key, channelName);
        return (RouterSpec)this._this();
    }

    public RouterSpec<R> subFlowMapping(String key, IntegrationFlow subFlow) {
        Assert.hasText((String)key);
        Assert.notNull((Object)subFlow);
        Assert.state((!StringUtils.hasText((String)this.prefix) && !StringUtils.hasText((String)this.suffix) ? 1 : 0) != 0, (String)"The 'prefix'('suffix') and 'subFlowMapping' are mutually exclusive");
        DirectChannel channel = new DirectChannel();
        IntegrationFlowBuilder flowBuilder = IntegrationFlows.from((MessageChannel)channel);
        subFlow.configure(flowBuilder);
        this.subFlows.add(flowBuilder);
        if (this.mappingProvider == null) {
            this.mappingProvider = new RouterSubFlowMappingProvider((MappingMessageRouterManagement)this.target);
        }
        this.mappingProvider.addMapping(key, (NamedComponent)channel);
        return (RouterSpec)this._this();
    }

    @Override
    public Collection<Object> getComponentsToRegister() {
        if (this.mappingProvider != null) {
            this.subFlows.add(this.mappingProvider);
        }
        return this.subFlows;
    }

    private static class RouterSubFlowMappingProvider {
        private final MappingMessageRouterManagement router;
        private final Map<String, NamedComponent> mapping = new HashMap<String, NamedComponent>();

        public RouterSubFlowMappingProvider(MappingMessageRouterManagement router) {
            this.router = router;
        }

        void addMapping(String key, NamedComponent channel) {
            this.mapping.put(key, channel);
        }

        @PostConstruct
        public void init() {
            for (Map.Entry<String, NamedComponent> entry : this.mapping.entrySet()) {
                this.router.setChannelMapping(entry.getKey(), entry.getValue().getComponentName());
            }
        }
    }
}

