/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.kafka;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kafka.javaapi.producer.Producer;
import kafka.producer.Partitioner;
import kafka.serializer.Encoder;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.dsl.core.MessageHandlerSpec;
import org.springframework.integration.dsl.support.Consumer;
import org.springframework.integration.dsl.support.Function;
import org.springframework.integration.dsl.support.FunctionExpression;
import org.springframework.integration.kafka.outbound.KafkaProducerMessageHandler;
import org.springframework.integration.kafka.support.KafkaProducerContext;
import org.springframework.integration.kafka.support.ProducerConfiguration;
import org.springframework.integration.kafka.support.ProducerFactoryBean;
import org.springframework.integration.kafka.support.ProducerMetadata;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class KafkaProducerMessageHandlerSpec
extends MessageHandlerSpec<KafkaProducerMessageHandlerSpec, KafkaProducerMessageHandler>
implements ComponentsRegistration {
    private final KafkaProducerContext kafkaProducerContext;
    private final Properties producerProperties;
    private final Map<String, ProducerConfiguration> producerConfigurations = new HashMap<String, ProducerConfiguration>();

    KafkaProducerMessageHandlerSpec(Properties producerProperties) {
        this.producerProperties = producerProperties;
        this.kafkaProducerContext = new KafkaProducerContext();
        this.target = new KafkaProducerMessageHandler(this.kafkaProducerContext);
    }

    public KafkaProducerMessageHandlerSpec topicExpression(String topicExpression) {
        ((KafkaProducerMessageHandler)this.target).setTopicExpression(PARSER.parseExpression(topicExpression));
        return (KafkaProducerMessageHandlerSpec)this._this();
    }

    public <P> KafkaProducerMessageHandlerSpec topic(Function<Message<P>, String> topicFunction) {
        ((KafkaProducerMessageHandler)this.target).setTopicExpression(new FunctionExpression<Message<P>>(topicFunction));
        return (KafkaProducerMessageHandlerSpec)this._this();
    }

    public KafkaProducerMessageHandlerSpec messageKeyExpression(String messageKeyExpression) {
        ((KafkaProducerMessageHandler)this.target).setMessageKeyExpression(PARSER.parseExpression(messageKeyExpression));
        return (KafkaProducerMessageHandlerSpec)this._this();
    }

    public <P> KafkaProducerMessageHandlerSpec messageKey(Function<Message<P>, ?> messageKeyFunction) {
        ((KafkaProducerMessageHandler)this.target).setMessageKeyExpression(new FunctionExpression<Message<P>>(messageKeyFunction));
        return (KafkaProducerMessageHandlerSpec)this._this();
    }

    public KafkaProducerMessageHandlerSpec addProducer(String topic, String brokerList, Consumer<ProducerMetadataSpec> producerMetadataSpecConsumer) {
        Assert.hasText((String)topic);
        Assert.hasText((String)brokerList);
        Assert.notNull(producerMetadataSpecConsumer);
        ProducerMetadataSpec spec = new ProducerMetadataSpec(new ProducerMetadata(topic));
        producerMetadataSpecConsumer.accept(spec);
        try {
            ProducerMetadata producerMetadata = spec.producerMetadata;
            producerMetadata.afterPropertiesSet();
            ProducerFactoryBean producerFactoryBean = new ProducerFactoryBean(producerMetadata, brokerList, this.producerProperties);
            Producer producer = producerFactoryBean.getObject();
            this.producerConfigurations.put(topic, new ProducerConfiguration(producerMetadata, producer));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return (KafkaProducerMessageHandlerSpec)this._this();
    }

    @Override
    public Collection<Object> getComponentsToRegister() {
        this.kafkaProducerContext.setProducerConfigurations(this.producerConfigurations);
        return Collections.singleton(this.kafkaProducerContext);
    }

    @Override
    protected KafkaProducerMessageHandler doGet() {
        throw new UnsupportedOperationException();
    }

    public static class ProducerMetadataSpec {
        private final ProducerMetadata producerMetadata;

        ProducerMetadataSpec(ProducerMetadata producerMetadata) {
            this.producerMetadata = producerMetadata;
        }

        public <T> ProducerMetadataSpec valueEncoder(Encoder<T> valueEncoder) {
            this.producerMetadata.setValueEncoder(valueEncoder);
            return this;
        }

        public <T> ProducerMetadataSpec keyEncoder(Encoder<T> keyEncoder) {
            this.producerMetadata.setKeyEncoder(keyEncoder);
            return this;
        }

        public ProducerMetadataSpec keyClassType(Class<?> keyClassType) {
            this.producerMetadata.setKeyClassType(keyClassType);
            return this;
        }

        public ProducerMetadataSpec valueClassType(Class<?> valueClassType) {
            this.producerMetadata.setValueClassType(valueClassType);
            return this;
        }

        public ProducerMetadataSpec compressionCodec(String compressionCodec) {
            this.producerMetadata.setCompressionCodec(compressionCodec);
            return this;
        }

        public ProducerMetadataSpec partitioner(Partitioner partitioner) {
            this.producerMetadata.setPartitioner(partitioner);
            return this;
        }

        public ProducerMetadataSpec async(boolean async) {
            this.producerMetadata.setAsync(async);
            return this;
        }

        public ProducerMetadataSpec batchNumMessages(int batchNumMessages) {
            this.producerMetadata.setBatchNumMessages("" + batchNumMessages);
            return this;
        }
    }
}

