/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.file;

import java.io.File;
import java.util.Comparator;
import org.springframework.expression.Expression;
import org.springframework.integration.dsl.file.FileInboundChannelAdapterSpec;
import org.springframework.integration.dsl.file.FileSplitterSpec;
import org.springframework.integration.dsl.file.FileWritingMessageHandlerSpec;
import org.springframework.integration.dsl.file.TailAdapterSpec;
import org.springframework.integration.dsl.support.Function;
import org.springframework.messaging.Message;

public abstract class Files {
    public static FileInboundChannelAdapterSpec inboundAdapter(File directory) {
        return Files.inboundAdapter(directory, null);
    }

    public static FileInboundChannelAdapterSpec inboundAdapter(File directory, Comparator<File> receptionOrderComparator) {
        return new FileInboundChannelAdapterSpec(receptionOrderComparator).directory(directory);
    }

    public static FileWritingMessageHandlerSpec outboundAdapter(File destinationDirectory) {
        return new FileWritingMessageHandlerSpec(destinationDirectory).expectReply(false);
    }

    public static FileWritingMessageHandlerSpec outboundAdapter(String directoryExpression) {
        return new FileWritingMessageHandlerSpec(directoryExpression).expectReply(false);
    }

    public static FileWritingMessageHandlerSpec outboundAdapter(Expression directoryExpression) {
        return new FileWritingMessageHandlerSpec(directoryExpression).expectReply(false);
    }

    public static <P> FileWritingMessageHandlerSpec outboundAdapter(Function<Message<P>, ?> directoryFunction) {
        return new FileWritingMessageHandlerSpec(directoryFunction).expectReply(false);
    }

    public static FileWritingMessageHandlerSpec outboundGateway(File destinationDirectory) {
        return new FileWritingMessageHandlerSpec(destinationDirectory).expectReply(true);
    }

    public static FileWritingMessageHandlerSpec outboundGateway(String directoryExpression) {
        return new FileWritingMessageHandlerSpec(directoryExpression).expectReply(true);
    }

    public static FileWritingMessageHandlerSpec outboundGateway(Expression directoryExpression) {
        return new FileWritingMessageHandlerSpec(directoryExpression).expectReply(true);
    }

    public static <P> FileWritingMessageHandlerSpec outboundGateway(Function<Message<P>, ?> directoryFunction) {
        return new FileWritingMessageHandlerSpec(directoryFunction).expectReply(true);
    }

    public static TailAdapterSpec tailAdapter(File file) {
        return new TailAdapterSpec().file(file);
    }

    public static FileSplitterSpec splitter() {
        return Files.splitter(true);
    }

    public static FileSplitterSpec splitter(boolean iterator) {
        return Files.splitter(iterator, false);
    }

    public static FileSplitterSpec splitter(boolean iterator, boolean markers) {
        return new FileSplitterSpec(iterator, markers);
    }
}

