/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.springframework.expression.Expression;
import org.springframework.integration.aggregator.AbstractCorrelatingMessageHandler;
import org.springframework.integration.aggregator.CorrelationStrategy;
import org.springframework.integration.aggregator.ExpressionEvaluatingCorrelationStrategy;
import org.springframework.integration.aggregator.ExpressionEvaluatingReleaseStrategy;
import org.springframework.integration.aggregator.ReleaseStrategy;
import org.springframework.integration.config.CorrelationStrategyFactoryBean;
import org.springframework.integration.config.ReleaseStrategyFactoryBean;
import org.springframework.integration.dsl.core.ConsumerEndpointSpec;
import org.springframework.integration.dsl.support.Function;
import org.springframework.integration.dsl.support.FunctionExpression;
import org.springframework.integration.dsl.support.tuple.Tuple2;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageGroupStore;
import org.springframework.integration.support.locks.LockRegistry;
import org.springframework.messaging.MessageChannel;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;

public abstract class CorrelationHandlerSpec<S extends CorrelationHandlerSpec<S, H>, H extends AbstractCorrelatingMessageHandler>
extends ConsumerEndpointSpec<S, H> {
    private final List<Advice> forceReleaseAdviceChain = new LinkedList<Advice>();

    protected CorrelationHandlerSpec(H messageHandler) {
        super(messageHandler);
        messageHandler.setForceReleaseAdviceChain(this.forceReleaseAdviceChain);
    }

    public S messageStore(MessageGroupStore messageStore) {
        Assert.notNull((Object)messageStore);
        ((AbstractCorrelatingMessageHandler)((Tuple2)this.target).getT2()).setMessageStore(messageStore);
        return (S)((CorrelationHandlerSpec)this._this());
    }

    public S sendPartialResultOnExpiry(boolean sendPartialResultOnExpiry) {
        ((AbstractCorrelatingMessageHandler)((Tuple2)this.target).getT2()).setSendPartialResultOnExpiry(sendPartialResultOnExpiry);
        return (S)((CorrelationHandlerSpec)this._this());
    }

    public S minimumTimeoutForEmptyGroups(long minimumTimeoutForEmptyGroups) {
        ((AbstractCorrelatingMessageHandler)((Tuple2)this.target).getT2()).setMinimumTimeoutForEmptyGroups(minimumTimeoutForEmptyGroups);
        return (S)((CorrelationHandlerSpec)this._this());
    }

    public S groupTimeout(long groupTimeout) {
        ((AbstractCorrelatingMessageHandler)((Tuple2)this.target).getT2()).setGroupTimeoutExpression((Expression)new ValueExpression((Object)groupTimeout));
        return (S)((CorrelationHandlerSpec)this._this());
    }

    public S groupTimeoutExpression(String groupTimeoutExpression) {
        Assert.hasText((String)groupTimeoutExpression);
        ((AbstractCorrelatingMessageHandler)((Tuple2)this.target).getT2()).setGroupTimeoutExpression(PARSER.parseExpression(groupTimeoutExpression));
        return (S)((CorrelationHandlerSpec)this._this());
    }

    public S groupTimeout(Function<MessageGroup, Long> groupTimeoutFunction) {
        ((AbstractCorrelatingMessageHandler)((Tuple2)this.target).getT2()).setGroupTimeoutExpression(new FunctionExpression<MessageGroup>(groupTimeoutFunction));
        return (S)((CorrelationHandlerSpec)this._this());
    }

    public S taskScheduler(TaskScheduler taskScheduler) {
        Assert.notNull((Object)taskScheduler);
        ((AbstractCorrelatingMessageHandler)((Tuple2)this.target).getT2()).setTaskScheduler(taskScheduler);
        return (S)((CorrelationHandlerSpec)this._this());
    }

    public S discardChannel(MessageChannel discardChannel) {
        Assert.notNull((Object)discardChannel);
        ((AbstractCorrelatingMessageHandler)((Tuple2)this.target).getT2()).setDiscardChannel(discardChannel);
        return (S)((CorrelationHandlerSpec)this._this());
    }

    public S discardChannel(String discardChannelName) {
        Assert.hasText((String)discardChannelName);
        ((AbstractCorrelatingMessageHandler)((Tuple2)this.target).getT2()).setDiscardChannelName(discardChannelName);
        return (S)((CorrelationHandlerSpec)this._this());
    }

    public S processor(Object target) {
        try {
            CorrelationStrategyFactoryBean correlationStrategyFactoryBean = new CorrelationStrategyFactoryBean();
            correlationStrategyFactoryBean.setTarget(target);
            correlationStrategyFactoryBean.afterPropertiesSet();
            ReleaseStrategyFactoryBean releaseStrategyFactoryBean = new ReleaseStrategyFactoryBean();
            releaseStrategyFactoryBean.setTarget(target);
            releaseStrategyFactoryBean.afterPropertiesSet();
            return ((CorrelationHandlerSpec)this.correlationStrategy(correlationStrategyFactoryBean.getObject())).releaseStrategy(releaseStrategyFactoryBean.getObject());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public S correlationExpression(String correlationExpression) {
        return this.correlationStrategy((CorrelationStrategy)new ExpressionEvaluatingCorrelationStrategy(correlationExpression));
    }

    public S correlationStrategy(Object target, String methodName) {
        try {
            CorrelationStrategyFactoryBean correlationStrategyFactoryBean = new CorrelationStrategyFactoryBean();
            correlationStrategyFactoryBean.setTarget(target);
            correlationStrategyFactoryBean.setMethodName(methodName);
            correlationStrategyFactoryBean.afterPropertiesSet();
            return this.correlationStrategy(correlationStrategyFactoryBean.getObject());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public S correlationStrategy(CorrelationStrategy correlationStrategy) {
        ((AbstractCorrelatingMessageHandler)((Tuple2)this.target).getT2()).setCorrelationStrategy(correlationStrategy);
        return (S)((CorrelationHandlerSpec)this._this());
    }

    public S releaseExpression(String releaseExpression) {
        return this.releaseStrategy((ReleaseStrategy)new ExpressionEvaluatingReleaseStrategy(releaseExpression));
    }

    public S releaseStrategy(Object target, String methodName) {
        try {
            ReleaseStrategyFactoryBean releaseStrategyFactoryBean = new ReleaseStrategyFactoryBean();
            releaseStrategyFactoryBean.setTarget(target);
            releaseStrategyFactoryBean.setMethodName(methodName);
            releaseStrategyFactoryBean.afterPropertiesSet();
            return this.releaseStrategy(releaseStrategyFactoryBean.getObject());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public S releaseStrategy(ReleaseStrategy releaseStrategy) {
        ((AbstractCorrelatingMessageHandler)((Tuple2)this.target).getT2()).setReleaseStrategy(releaseStrategy);
        return (S)((CorrelationHandlerSpec)this._this());
    }

    public S expireGroupsUponTimeout(boolean expireGroupsUponTimeout) {
        ((AbstractCorrelatingMessageHandler)((Tuple2)this.target).getT2()).setExpireGroupsUponTimeout(expireGroupsUponTimeout);
        return (S)((CorrelationHandlerSpec)this._this());
    }

    public S forceReleaseAdvice(Advice ... advice) {
        this.forceReleaseAdviceChain.addAll(Arrays.asList(advice));
        return (S)((CorrelationHandlerSpec)this._this());
    }

    public S lockRegistry(LockRegistry lockRegistry) {
        Assert.notNull((Object)lockRegistry);
        ((AbstractCorrelatingMessageHandler)((Tuple2)this.target).getT2()).setLockRegistry(lockRegistry);
        return (S)((CorrelationHandlerSpec)this._this());
    }
}

