/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.dsl.AbstractRouterSpec;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.router.AbstractMappingMessageRouter;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.integration.support.management.MappingMessageRouterManagement;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class RouterSpec<K, R extends AbstractMappingMessageRouter>
extends AbstractRouterSpec<RouterSpec<K, R>, R>
implements ComponentsRegistration {
    private final RouterMappingProvider mappingProvider;
    private String prefix;
    private String suffix;

    RouterSpec(R router) {
        super(router);
        this.mappingProvider = new RouterMappingProvider((MappingMessageRouterManagement)this.target);
    }

    public RouterSpec<K, R> resolutionRequired(boolean resolutionRequired) {
        ((AbstractMappingMessageRouter)this.target).setResolutionRequired(resolutionRequired);
        return (RouterSpec)this._this();
    }

    public RouterSpec<K, R> prefix(String prefix) {
        Assert.state((boolean)this.subFlows.isEmpty(), (String)"The 'prefix'('suffix') and 'subFlowMapping' are mutually exclusive");
        this.prefix = prefix;
        ((AbstractMappingMessageRouter)this.target).setPrefix(prefix);
        return (RouterSpec)this._this();
    }

    public RouterSpec<K, R> suffix(String suffix) {
        Assert.state((boolean)this.subFlows.isEmpty(), (String)"The 'prefix'('suffix') and 'subFlowMapping' are mutually exclusive");
        this.suffix = suffix;
        ((AbstractMappingMessageRouter)this.target).setSuffix(suffix);
        return (RouterSpec)this._this();
    }

    public RouterSpec<K, R> channelMapping(K key, final String channelName) {
        Assert.notNull(key);
        Assert.hasText((String)channelName);
        if (key instanceof String) {
            ((AbstractMappingMessageRouter)this.target).setChannelMapping((String)key, channelName);
        } else {
            this.mappingProvider.addMapping(key, new NamedComponent(){

                public String getComponentName() {
                    return channelName;
                }

                public String getComponentType() {
                    return "channel";
                }
            });
        }
        return (RouterSpec)this._this();
    }

    public RouterSpec<K, R> subFlowMapping(K key, IntegrationFlow subFlow) {
        Assert.notNull(key);
        Assert.notNull((Object)subFlow);
        Assert.state((!StringUtils.hasText((String)this.prefix) && !StringUtils.hasText((String)this.suffix) ? 1 : 0) != 0, (String)"The 'prefix'('suffix') and 'subFlowMapping' are mutually exclusive");
        DirectChannel channel = new DirectChannel();
        IntegrationFlowBuilder flowBuilder = IntegrationFlows.from((MessageChannel)channel);
        subFlow.configure(flowBuilder);
        this.subFlows.add(flowBuilder);
        this.mappingProvider.addMapping(key, (NamedComponent)channel);
        return (RouterSpec)this._this();
    }

    @Override
    public Collection<Object> getComponentsToRegister() {
        this.subFlows.add(this.mappingProvider);
        return super.getComponentsToRegister();
    }

    private static class RouterMappingProvider
    extends IntegrationObjectSupport {
        private final MappingMessageRouterManagement router;
        private final Map<Object, NamedComponent> mapping = new HashMap<Object, NamedComponent>();

        RouterMappingProvider(MappingMessageRouterManagement router) {
            this.router = router;
        }

        void addMapping(Object key, NamedComponent channel) {
            this.mapping.put(key, channel);
        }

        protected void onInit() throws Exception {
            ConversionService conversionService = this.getConversionService();
            if (conversionService == null) {
                conversionService = new DefaultConversionService();
            }
            for (Map.Entry<Object, NamedComponent> entry : this.mapping.entrySet()) {
                String channelKey;
                Object key = entry.getKey();
                if (key instanceof String) {
                    channelKey = (String)key;
                } else if (key instanceof Class) {
                    channelKey = ((Class)key).getName();
                } else if (conversionService.canConvert(key.getClass(), String.class)) {
                    channelKey = (String)conversionService.convert(key, String.class);
                } else {
                    throw new MessagingException("unsupported channel mapping type for router [" + key.getClass() + "]");
                }
                this.router.setChannelMapping(channelKey, entry.getValue().getComponentName());
            }
        }
    }
}

