/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.file;

import java.io.File;
import java.util.Comparator;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.integration.dsl.core.MessageSourceSpec;
import org.springframework.integration.file.DirectoryScanner;
import org.springframework.integration.file.FileLocker;
import org.springframework.integration.file.FileReadingMessageSource;
import org.springframework.integration.file.config.FileListFilterFactoryBean;
import org.springframework.integration.file.filters.AcceptOnceFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.filters.IgnoreHiddenFileListFilter;
import org.springframework.integration.file.locking.NioFileLocker;
import org.springframework.util.Assert;

public class FileInboundChannelAdapterSpec
extends MessageSourceSpec<FileInboundChannelAdapterSpec, FileReadingMessageSource> {
    private final FileListFilterFactoryBean fileListFilterFactoryBean = new FileListFilterFactoryBean();
    private FileLocker locker;

    FileInboundChannelAdapterSpec() {
        this.target = new FileReadingMessageSource();
    }

    FileInboundChannelAdapterSpec(Comparator<File> receptionOrderComparator) {
        this.target = new FileReadingMessageSource(receptionOrderComparator){

            protected void onInit() {
                try {
                    this.setFilter(FileInboundChannelAdapterSpec.this.fileListFilterFactoryBean.getObject());
                }
                catch (Exception e) {
                    throw new BeanCreationException("The bean for the [" + (Object)((Object)this) + "] can not be instantiated.", (Throwable)e);
                }
                super.onInit();
            }
        };
    }

    FileInboundChannelAdapterSpec directory(File directory) {
        ((FileReadingMessageSource)this.target).setDirectory(directory);
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec scanner(DirectoryScanner scanner) {
        ((FileReadingMessageSource)this.target).setScanner(scanner);
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec autoCreateDirectory(boolean autoCreateDirectory) {
        ((FileReadingMessageSource)this.target).setAutoCreateDirectory(autoCreateDirectory);
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec filter(FileListFilter<File> filter) {
        this.fileListFilterFactoryBean.setFilter(filter);
        return (FileInboundChannelAdapterSpec)this._this();
    }

    @Deprecated
    public FileInboundChannelAdapterSpec filter(FileListFilter<File> filter, boolean preventDuplicates) {
        return this.filter(filter).preventDuplicates(preventDuplicates);
    }

    @Deprecated
    public FileInboundChannelAdapterSpec preventDuplicatesFilter(boolean preventDuplicates) {
        return this.preventDuplicates(preventDuplicates);
    }

    public FileInboundChannelAdapterSpec preventDuplicates(boolean preventDuplicates) {
        this.fileListFilterFactoryBean.setPreventDuplicates(Boolean.valueOf(preventDuplicates));
        return (FileInboundChannelAdapterSpec)this._this();
    }

    @Deprecated
    public FileInboundChannelAdapterSpec preventDuplicates() {
        return this.filter((FileListFilter<File>)new AcceptOnceFileListFilter());
    }

    @Deprecated
    public FileInboundChannelAdapterSpec ignoreHidden() {
        return this.filter((FileListFilter<File>)new IgnoreHiddenFileListFilter());
    }

    public FileInboundChannelAdapterSpec ignoreHidden(boolean ignoreHidden) {
        this.fileListFilterFactoryBean.setIgnoreHidden(Boolean.valueOf(ignoreHidden));
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec patternFilter(String pattern) {
        this.fileListFilterFactoryBean.setFilenamePattern(pattern);
        return (FileInboundChannelAdapterSpec)this._this();
    }

    @Deprecated
    public FileInboundChannelAdapterSpec patternFilter(String pattern, boolean preventDuplicates) {
        return this.patternFilter(pattern).preventDuplicates(preventDuplicates);
    }

    public FileInboundChannelAdapterSpec regexFilter(String regex) {
        this.fileListFilterFactoryBean.setFilenameRegex(regex);
        return (FileInboundChannelAdapterSpec)this._this();
    }

    @Deprecated
    public FileInboundChannelAdapterSpec regexFilter(String regex, boolean preventDuplicates) {
        return this.regexFilter(regex).preventDuplicates(preventDuplicates);
    }

    public FileInboundChannelAdapterSpec locker(FileLocker locker) {
        Assert.isNull((Object)this.locker, (String)("The 'locker' (" + this.locker + ") is already configured for the FileReadingMessageSource"));
        this.locker = locker;
        ((FileReadingMessageSource)this.target).setLocker(locker);
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec nioLocker() {
        return this.locker((FileLocker)new NioFileLocker());
    }

    public FileInboundChannelAdapterSpec scanEachPoll(boolean scanEachPoll) {
        ((FileReadingMessageSource)this.target).setScanEachPoll(scanEachPoll);
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec useWatchService(boolean useWatchService) {
        ((FileReadingMessageSource)this.target).setUseWatchService(useWatchService);
        return this;
    }

    public FileInboundChannelAdapterSpec watchEvents(FileReadingMessageSource.WatchEventType ... watchEvents) {
        ((FileReadingMessageSource)this.target).setWatchEvents(watchEvents);
        return this;
    }
}

