/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.http;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.expression.Expression;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.dsl.core.MessagingGatewaySpec;
import org.springframework.integration.dsl.support.Consumer;
import org.springframework.integration.dsl.support.Function;
import org.springframework.integration.dsl.support.FunctionExpression;
import org.springframework.integration.http.inbound.CrossOrigin;
import org.springframework.integration.http.inbound.HttpRequestHandlingEndpointSupport;
import org.springframework.integration.http.inbound.RequestMapping;
import org.springframework.integration.http.support.DefaultHttpHeaderMapper;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartResolver;

public abstract class BaseHttpInboundEndpointSpec<S extends BaseHttpInboundEndpointSpec<S, E>, E extends HttpRequestHandlingEndpointSupport>
extends MessagingGatewaySpec<S, E>
implements ComponentsRegistration {
    private final RequestMapping requestMapping = new RequestMapping();
    private final Map<String, Expression> headerExpressions = new HashMap<String, Expression>();
    private final HeaderMapper<HttpHeaders> headerMapper = DefaultHttpHeaderMapper.inboundMapper();
    private HeaderMapper<HttpHeaders> explicitHeaderMapper;

    BaseHttpInboundEndpointSpec(E endpoint, String ... path) {
        super(endpoint);
        this.requestMapping.setPathPatterns(path);
        ((HttpRequestHandlingEndpointSupport)this.target).setRequestMapping(this.requestMapping);
        ((HttpRequestHandlingEndpointSupport)this.target).setHeaderExpressions(this.headerExpressions);
        ((HttpRequestHandlingEndpointSupport)this.target).setHeaderMapper(this.headerMapper);
    }

    public S requestMapping(Consumer<RequestMappingSpec> requestMapping) {
        requestMapping.accept(new RequestMappingSpec(this.requestMapping));
        return (S)((BaseHttpInboundEndpointSpec)this._this());
    }

    public S crossOrigin(Consumer<CrossOriginSpec> crossOrigin) {
        CrossOriginSpec originSpec = new CrossOriginSpec();
        crossOrigin.accept(originSpec);
        ((HttpRequestHandlingEndpointSupport)this.target).setCrossOrigin(originSpec.crossOrigin);
        return (S)((BaseHttpInboundEndpointSpec)this._this());
    }

    public S payloadExpression(String payloadExpression) {
        return this.payloadExpression(PARSER.parseExpression(payloadExpression));
    }

    public S payloadExpression(Expression payloadExpression) {
        ((HttpRequestHandlingEndpointSupport)this.target).setPayloadExpression(payloadExpression);
        return (S)((BaseHttpInboundEndpointSpec)this._this());
    }

    public <P> S payloadFunction(Function<HttpEntity<P>, ?> payloadFunction) {
        return this.payloadExpression(new FunctionExpression<HttpEntity<P>>(payloadFunction));
    }

    public S headerExpressions(Map<String, Expression> headerExpressions) {
        Assert.notNull(headerExpressions, (String)"'headerExpressions' must not be null");
        this.headerExpressions.clear();
        this.headerExpressions.putAll(headerExpressions);
        return (S)((BaseHttpInboundEndpointSpec)this._this());
    }

    public S headerExpression(String header, Expression expression) {
        this.headerExpressions.put(header, expression);
        return (S)((BaseHttpInboundEndpointSpec)this._this());
    }

    public S headerExpression(String header, String expression) {
        return this.headerExpression(header, PARSER.parseExpression(expression));
    }

    public S headerFunction(String header, Function<HttpEntity<?>, ?> headerFunction) {
        return this.headerExpression(header, new FunctionExpression(headerFunction));
    }

    public S messageConverters(HttpMessageConverter<?> ... messageConverters) {
        ((HttpRequestHandlingEndpointSupport)this.target).setMessageConverters(Arrays.asList(messageConverters));
        return (S)((BaseHttpInboundEndpointSpec)this._this());
    }

    public S mergeWithDefaultConverters(boolean mergeWithDefaultConverters) {
        ((HttpRequestHandlingEndpointSupport)this.target).setMergeWithDefaultConverters(mergeWithDefaultConverters);
        return (S)((BaseHttpInboundEndpointSpec)this._this());
    }

    public S headerMapper(HeaderMapper<HttpHeaders> headerMapper) {
        ((HttpRequestHandlingEndpointSupport)this.target).setHeaderMapper(headerMapper);
        this.explicitHeaderMapper = headerMapper;
        return (S)((BaseHttpInboundEndpointSpec)this._this());
    }

    public S mappedRequestHeaders(String ... patterns) {
        Assert.isNull(this.explicitHeaderMapper, (String)("The 'mappedRequestHeaders' must be specified on the provided 'headerMapper': " + this.explicitHeaderMapper));
        ((DefaultHttpHeaderMapper)this.headerMapper).setOutboundHeaderNames(patterns);
        return (S)((BaseHttpInboundEndpointSpec)this._this());
    }

    public S mappedResponseHeaders(String ... patterns) {
        Assert.isNull(this.explicitHeaderMapper, (String)("The 'mappedRequestHeaders' must be specified on the provided 'headerMapper': " + this.explicitHeaderMapper));
        ((DefaultHttpHeaderMapper)this.headerMapper).setInboundHeaderNames(patterns);
        return (S)((BaseHttpInboundEndpointSpec)this._this());
    }

    public S requestPayloadType(Class<?> requestPayloadType) {
        ((HttpRequestHandlingEndpointSupport)this.target).setRequestPayloadType(requestPayloadType);
        return (S)((BaseHttpInboundEndpointSpec)this._this());
    }

    public S extractReplyPayload(boolean extractReplyPayload) {
        ((HttpRequestHandlingEndpointSupport)this.target).setExtractReplyPayload(extractReplyPayload);
        return (S)((BaseHttpInboundEndpointSpec)this._this());
    }

    public S multipartResolver(MultipartResolver multipartResolver) {
        ((HttpRequestHandlingEndpointSupport)this.target).setMultipartResolver(multipartResolver);
        return (S)((BaseHttpInboundEndpointSpec)this._this());
    }

    public S statusCodeExpression(Expression statusCodeExpression) {
        ((HttpRequestHandlingEndpointSupport)this.target).setStatusCodeExpression(statusCodeExpression);
        return (S)((BaseHttpInboundEndpointSpec)this._this());
    }

    public S statusCodeFunction(Function<Void, ?> statusCodeFunction) {
        return this.payloadExpression(new FunctionExpression<Void>(statusCodeFunction));
    }

    @Override
    public Collection<Object> getComponentsToRegister() {
        HeaderMapper<HttpHeaders> headerMapperToRegister = this.explicitHeaderMapper != null ? this.explicitHeaderMapper : this.headerMapper;
        return Collections.singletonList(headerMapperToRegister);
    }

    public static final class CrossOriginSpec {
        private final CrossOrigin crossOrigin = new CrossOrigin();

        private CrossOriginSpec() {
        }

        public CrossOriginSpec origin(String ... origin) {
            this.crossOrigin.setOrigin(origin);
            return this;
        }

        public CrossOriginSpec allowedHeaders(String ... allowedHeaders) {
            this.crossOrigin.setAllowedHeaders(allowedHeaders);
            return this;
        }

        public CrossOriginSpec exposedHeaders(String ... exposedHeaders) {
            this.crossOrigin.setExposedHeaders(exposedHeaders);
            return this;
        }

        public CrossOriginSpec method(RequestMethod ... method) {
            this.crossOrigin.setMethod(method);
            return this;
        }

        public CrossOriginSpec allowCredentials(Boolean allowCredentials) {
            this.crossOrigin.setAllowCredentials(allowCredentials);
            return this;
        }

        public CrossOriginSpec maxAge(long maxAge) {
            this.crossOrigin.setMaxAge(maxAge);
            return this;
        }
    }

    public static final class RequestMappingSpec {
        private final RequestMapping requestMapping;

        private RequestMappingSpec(RequestMapping requestMapping) {
            this.requestMapping = requestMapping;
        }

        public RequestMappingSpec methods(HttpMethod ... supportedMethods) {
            this.requestMapping.setMethods(supportedMethods);
            return this;
        }

        public RequestMappingSpec params(String ... params) {
            this.requestMapping.setParams(params);
            return this;
        }

        public RequestMappingSpec headers(String ... headers) {
            this.requestMapping.setHeaders(headers);
            return this;
        }

        public RequestMappingSpec consumes(String ... consumes) {
            this.requestMapping.setConsumes(consumes);
            return this;
        }

        public RequestMappingSpec produces(String ... produces) {
            this.requestMapping.setProduces(produces);
            return this;
        }
    }
}

