/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.Lifecycle;
import org.springframework.integration.gateway.GatewayProxyFactoryBean;
import org.springframework.integration.gateway.RequestReplyExchanger;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.StringUtils;

class GatewayMessageHandler
extends AbstractReplyProducingMessageHandler
implements Lifecycle {
    private final GatewayProxyFactoryBean gatewayProxyFactoryBean = new GatewayProxyFactoryBean();
    private RequestReplyExchanger exchanger;
    private String requestChannel;
    private String replyChannel;
    private String errorChannel;
    private volatile boolean running;

    GatewayMessageHandler() {
        this.gatewayProxyFactoryBean.setServiceInterface(RequestReplyExchanger.class);
    }

    void setRequestChannel(MessageChannel requestChannel) {
        this.gatewayProxyFactoryBean.setDefaultRequestChannel(requestChannel);
    }

    void setRequestChannelName(String requestChannel) {
        this.requestChannel = requestChannel;
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.gatewayProxyFactoryBean.setDefaultReplyChannel(replyChannel);
    }

    public void setReplyChannelName(String replyChannel) {
        this.replyChannel = replyChannel;
    }

    public void setErrorChannel(MessageChannel errorChannel) {
        this.gatewayProxyFactoryBean.setErrorChannel(errorChannel);
    }

    public void setErrorChannelName(String errorChannel) {
        this.errorChannel = errorChannel;
    }

    public void setRequestTimeout(Long requestTimeout) {
        this.gatewayProxyFactoryBean.setDefaultRequestTimeout(requestTimeout);
    }

    public void setReplyTimeout(Long replyTimeout) {
        this.gatewayProxyFactoryBean.setDefaultReplyTimeout(replyTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleRequestMessage(Message<?> requestMessage) {
        if (this.exchanger == null) {
            GatewayMessageHandler gatewayMessageHandler = this;
            synchronized (gatewayMessageHandler) {
                if (this.exchanger == null) {
                    this.initialize();
                }
            }
        }
        return this.exchanger.exchange(requestMessage);
    }

    private void initialize() {
        BeanFactory beanFactory = this.getBeanFactory();
        if (StringUtils.hasText((String)this.requestChannel)) {
            this.gatewayProxyFactoryBean.setDefaultRequestChannel((MessageChannel)beanFactory.getBean(this.requestChannel, MessageChannel.class));
        }
        if (StringUtils.hasText((String)this.replyChannel)) {
            this.gatewayProxyFactoryBean.setDefaultReplyChannel((MessageChannel)beanFactory.getBean(this.replyChannel, MessageChannel.class));
        }
        if (StringUtils.hasText((String)this.errorChannel)) {
            this.gatewayProxyFactoryBean.setErrorChannel((MessageChannel)beanFactory.getBean(this.errorChannel, MessageChannel.class));
        }
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            ((ConfigurableListableBeanFactory)beanFactory).initializeBean((Object)this.gatewayProxyFactoryBean, null);
        }
        try {
            this.exchanger = (RequestReplyExchanger)this.gatewayProxyFactoryBean.getObject();
        }
        catch (Exception e) {
            throw new BeanCreationException("Can't instantiate the GatewayProxyFactoryBean: " + (Object)((Object)this), (Throwable)e);
        }
        if (this.running) {
            this.gatewayProxyFactoryBean.stop();
            this.gatewayProxyFactoryBean.start();
        }
    }

    public void start() {
        this.gatewayProxyFactoryBean.start();
        this.running = true;
    }

    public void stop() {
        this.gatewayProxyFactoryBean.stop();
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }
}

