/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowDefinition;

public class StandardIntegrationFlow
implements IntegrationFlow,
SmartLifecycle {
    private final List<Object> integrationComponents;
    private final List<SmartLifecycle> lifecycles = new LinkedList<SmartLifecycle>();
    private final boolean registerComponents = true;
    private boolean running;

    StandardIntegrationFlow(Set<Object> integrationComponents) {
        this.integrationComponents = new LinkedList<Object>(integrationComponents);
    }

    public boolean isRegisterComponents() {
        return this.registerComponents;
    }

    public void setIntegrationComponents(List<Object> integrationComponents) {
        this.integrationComponents.clear();
        this.integrationComponents.addAll(integrationComponents);
    }

    public List<Object> getIntegrationComponents() {
        return this.integrationComponents;
    }

    @Override
    public void configure(IntegrationFlowDefinition<?> flow) {
        throw new UnsupportedOperationException();
    }

    public void start() {
        if (!this.running) {
            ListIterator<Object> iterator = this.integrationComponents.listIterator(this.integrationComponents.size());
            this.lifecycles.clear();
            while (iterator.hasPrevious()) {
                Object component = iterator.previous();
                if (!(component instanceof SmartLifecycle)) continue;
                this.lifecycles.add((SmartLifecycle)component);
                ((SmartLifecycle)component).start();
            }
            this.running = true;
        }
    }

    public void stop(Runnable callback) {
        if (this.lifecycles.size() > 0) {
            AggregatingCallback aggregatingCallback = new AggregatingCallback(this.lifecycles.size(), callback);
            ListIterator<SmartLifecycle> iterator = this.lifecycles.listIterator(this.lifecycles.size());
            while (iterator.hasPrevious()) {
                SmartLifecycle lifecycle = iterator.previous();
                if (lifecycle.isRunning()) {
                    lifecycle.stop((Runnable)aggregatingCallback);
                    continue;
                }
                aggregatingCallback.run();
            }
        } else {
            callback.run();
        }
        this.running = false;
    }

    public void stop() {
        ListIterator<SmartLifecycle> iterator = this.lifecycles.listIterator(this.lifecycles.size());
        while (iterator.hasPrevious()) {
            iterator.previous().stop();
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isAutoStartup() {
        return false;
    }

    public int getPhase() {
        return 0;
    }

    private static final class AggregatingCallback
    implements Runnable {
        private final AtomicInteger count;
        private final Runnable finishCallback;

        private AggregatingCallback(int count, Runnable finishCallback) {
            this.count = new AtomicInteger(count);
            this.finishCallback = finishCallback;
        }

        @Override
        public void run() {
            if (this.count.decrementAndGet() <= 0) {
                this.finishCallback.run();
            }
        }
    }
}

