/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.amqp;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.integration.amqp.outbound.AmqpOutboundEndpoint;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.dsl.amqp.AmqpBaseOutboundEndpointSpec;
import org.springframework.util.Assert;

public class AmqpOutboundEndpointSpec
extends AmqpBaseOutboundEndpointSpec<AmqpOutboundEndpointSpec, AmqpOutboundEndpoint> {
    private final boolean expectReply;

    AmqpOutboundEndpointSpec(AmqpTemplate amqpTemplate, boolean expectReply) {
        this.expectReply = expectReply;
        this.target = new AmqpOutboundEndpoint(amqpTemplate);
        ((AmqpOutboundEndpoint)this.target).setExpectReply(expectReply);
        ((AmqpOutboundEndpoint)this.target).setHeaderMapper((AmqpHeaderMapper)this.headerMapper);
        if (expectReply) {
            ((AmqpOutboundEndpoint)this.target).setRequiresReply(true);
        }
    }

    @Override
    public AmqpOutboundEndpointSpec mappedReplyHeaders(String ... headers) {
        Assert.isTrue((boolean)this.expectReply, (String)"'mappedReplyHeaders' can be applied only for gateway");
        return (AmqpOutboundEndpointSpec)super.mappedReplyHeaders(headers);
    }
}

