/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.Message;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.jdbc.ExpressionEvaluatingSqlParameterSourceFactory;
import org.springframework.integration.jdbc.JdbcMessageHandler;
import org.springframework.integration.jdbc.JdbcPollingChannelAdapter;
import org.springframework.integration.jdbc.SqlParameterSourceFactory;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcOutboundGateway
extends AbstractReplyProducingMessageHandler
implements InitializingBean {
    private final JdbcMessageHandler handler;
    private final JdbcPollingChannelAdapter poller;
    private volatile SqlParameterSourceFactory sqlParameterSourceFactory = new ExpressionEvaluatingSqlParameterSourceFactory();
    private volatile boolean keysGenerated;
    private volatile Integer maxRowsPerPoll;

    public JdbcOutboundGateway(DataSource dataSource, String updateQuery) {
        this((JdbcOperations)new JdbcTemplate(dataSource), updateQuery, null);
    }

    public JdbcOutboundGateway(DataSource dataSource, String updateQuery, String selectQuery) {
        this((JdbcOperations)new JdbcTemplate(dataSource), updateQuery, selectQuery);
    }

    public JdbcOutboundGateway(JdbcOperations jdbcOperations, String updateQuery) {
        this(jdbcOperations, updateQuery, null);
    }

    public JdbcOutboundGateway(JdbcOperations jdbcOperations, String updateQuery, String selectQuery) {
        Assert.notNull((Object)jdbcOperations, (String)"'jdbcOperations' must not be null.");
        if (!StringUtils.hasText((String)updateQuery) && !StringUtils.hasText((String)selectQuery)) {
            throw new IllegalArgumentException("The 'updateQuery' and the 'selectQuery' must not both be null or empty.");
        }
        if (StringUtils.hasText((String)selectQuery)) {
            this.poller = new JdbcPollingChannelAdapter(jdbcOperations, selectQuery);
            this.poller.setMaxRowsPerPoll(1);
        } else {
            this.poller = null;
        }
        this.handler = StringUtils.hasText((String)updateQuery) ? new JdbcMessageHandler(jdbcOperations, updateQuery) : null;
    }

    public void setMaxRowsPerPoll(Integer maxRowsPerPoll) {
        Assert.notNull((Object)maxRowsPerPoll, (String)"MaxRowsPerPoll must not be null.");
        this.maxRowsPerPoll = maxRowsPerPoll;
    }

    protected void onInit() {
        super.onInit();
        if (this.maxRowsPerPoll != null) {
            Assert.notNull((Object)((Object)this.poller), (String)"If you want to set 'maxRowsPerPoll', then you must provide a 'selectQuery'.");
            this.poller.setMaxRowsPerPoll(this.maxRowsPerPoll);
        }
        if (this.handler != null) {
            this.handler.afterPropertiesSet();
        }
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        List<Object> list = this.handler != null ? this.handler.executeUpdateQuery(requestMessage, this.keysGenerated) : Collections.emptyList();
        if (this.poller != null) {
            SqlParameterSource sqlQueryParameterSource = this.sqlParameterSourceFactory.createParameterSource(requestMessage);
            if (this.keysGenerated && !list.isEmpty()) {
                sqlQueryParameterSource = list.size() == 1 ? this.sqlParameterSourceFactory.createParameterSource(list.get(0)) : this.sqlParameterSourceFactory.createParameterSource(list);
            }
            if ((list = this.poller.doPoll(sqlQueryParameterSource)).isEmpty()) {
                return null;
            }
        }
        Object payload = list;
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            payload = list.get(0);
        }
        return MessageBuilder.withPayload(payload).copyHeaders((Map)requestMessage.getHeaders()).build();
    }

    public void setKeysGenerated(boolean keysGenerated) {
        this.keysGenerated = keysGenerated;
    }

    public void setRequestSqlParameterSourceFactory(SqlParameterSourceFactory sqlParameterSourceFactory) {
        this.handler.setSqlParameterSourceFactory(sqlParameterSourceFactory);
    }

    public void setReplySqlParameterSourceFactory(SqlParameterSourceFactory sqlParameterSourceFactory) {
        this.sqlParameterSourceFactory = sqlParameterSourceFactory;
    }

    public void setRowMapper(RowMapper<?> rowMapper) {
        this.poller.setRowMapper(rowMapper);
    }
}

