/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import java.util.Map;
import org.springframework.integration.Message;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.jdbc.StoredProcExecutor;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;

public class StoredProcOutboundGateway
extends AbstractReplyProducingMessageHandler {
    private final StoredProcExecutor executor;
    private volatile boolean expectSingleResult = false;

    public StoredProcOutboundGateway(StoredProcExecutor storedProcExecutor) {
        Assert.notNull((Object)storedProcExecutor, (String)"storedProcExecutor must not be null.");
        this.executor = storedProcExecutor;
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        Object payload;
        Map<String, Object> resultMap = this.executor.executeStoredProcedure(requestMessage);
        if (resultMap.isEmpty()) {
            return null;
        }
        if (this.expectSingleResult && resultMap.size() == 1) {
            payload = resultMap.values().iterator().next();
        } else {
            if (this.expectSingleResult && resultMap.size() > 1) {
                throw new MessageHandlingException(requestMessage, "Stored Procedure/Function call returned more than 1 result object and expectSingleResult was 'true'. ");
            }
            payload = resultMap;
        }
        return MessageBuilder.withPayload(payload).copyHeaders((Map)requestMessage.getHeaders()).build();
    }

    public void setExpectSingleResult(boolean expectSingleResult) {
        this.expectSingleResult = expectSingleResult;
    }
}

