/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import java.util.Map;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.Message;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.jms.DefaultJmsHeaderMapper;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.jms.listener.SessionAwareMessageListener;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.DynamicDestinationResolver;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelPublishingJmsMessageListener
extends MessagingGatewaySupport
implements SessionAwareMessageListener<javax.jms.Message>,
InitializingBean {
    private volatile boolean expectReply;
    private volatile MessageConverter messageConverter = new SimpleMessageConverter();
    private volatile boolean extractRequestPayload = true;
    private volatile boolean extractReplyPayload = true;
    private volatile Object defaultReplyDestination;
    private volatile long replyTimeToLive = 0L;
    private volatile int replyPriority = 4;
    private volatile int replyDeliveryMode = 2;
    private volatile boolean explicitQosEnabledForReplies;
    private volatile DestinationResolver destinationResolver = new DynamicDestinationResolver();
    private volatile JmsHeaderMapper headerMapper = new DefaultJmsHeaderMapper();

    public String getComponentType() {
        if (this.expectReply) {
            return "jms:inbound-gateway";
        }
        return "jms:message-driven-channel-adapter";
    }

    public void setExpectReply(boolean expectReply) {
        this.expectReply = expectReply;
    }

    public void setDefaultReplyDestination(Destination defaultReplyDestination) {
        this.defaultReplyDestination = defaultReplyDestination;
    }

    public void setDefaultReplyQueueName(String destinationName) {
        this.defaultReplyDestination = new DestinationNameHolder(destinationName, false);
    }

    public void setDefaultReplyTopicName(String destinationName) {
        this.defaultReplyDestination = new DestinationNameHolder(destinationName, true);
    }

    public void setReplyTimeToLive(long replyTimeToLive) {
        this.replyTimeToLive = replyTimeToLive;
    }

    public void setReplyPriority(int replyPriority) {
        this.replyPriority = replyPriority;
    }

    public void setReplyDeliveryPersistent(boolean replyDeliveryPersistent) {
        this.replyDeliveryMode = replyDeliveryPersistent ? 2 : 1;
    }

    public void setExplicitQosEnabledForReplies(boolean explicitQosEnabledForReplies) {
        this.explicitQosEnabledForReplies = explicitQosEnabledForReplies;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        Assert.notNull((Object)destinationResolver, (String)"destinationResolver must not be null");
        this.destinationResolver = destinationResolver;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setHeaderMapper(JmsHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    public void setExtractRequestPayload(boolean extractRequestPayload) {
        this.extractRequestPayload = extractRequestPayload;
    }

    public void setExtractReplyPayload(boolean extractReplyPayload) {
        this.extractReplyPayload = extractReplyPayload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(javax.jms.Message jmsMessage, Session session) throws JMSException {
        Message requestMessage;
        Object result = jmsMessage;
        if (this.extractRequestPayload) {
            result = this.messageConverter.fromMessage(jmsMessage);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("converted JMS Message [" + jmsMessage + "] to integration Message payload [" + result + "]"));
            }
        }
        Map headers = this.headerMapper.toHeaders(jmsMessage);
        Message message = requestMessage = result instanceof Message ? MessageBuilder.fromMessage((Message)((Message)result)).copyHeaders(headers).build() : MessageBuilder.withPayload((Object)result).copyHeaders(headers).build();
        if (!this.expectReply) {
            this.send(requestMessage);
        } else {
            Destination destination;
            Message replyMessage = this.sendAndReceiveMessage(requestMessage);
            if (replyMessage != null && (destination = this.getReplyDestination(jmsMessage, session)) != null) {
                Object replyResult = replyMessage;
                if (this.extractReplyPayload) {
                    replyResult = replyMessage.getPayload();
                }
                try {
                    javax.jms.Message jmsReply = this.messageConverter.toMessage(replyResult, session);
                    this.headerMapper.fromHeaders(replyMessage.getHeaders(), jmsReply);
                    if (jmsReply.getJMSCorrelationID() == null) {
                        jmsReply.setJMSCorrelationID(jmsMessage.getJMSMessageID());
                    }
                    MessageProducer producer = session.createProducer(destination);
                    try {
                        if (this.explicitQosEnabledForReplies) {
                            producer.send(jmsReply, this.replyDeliveryMode, this.replyPriority, this.replyTimeToLive);
                        } else {
                            producer.send(jmsReply);
                        }
                    }
                    finally {
                        producer.close();
                    }
                }
                catch (RuntimeException e) {
                    this.logger.error((Object)("Failed to generate JMS Reply Message from: " + replyResult), (Throwable)e);
                    throw e;
                }
            }
        }
    }

    private Destination getReplyDestination(javax.jms.Message request, Session session) throws JMSException {
        Destination replyTo = request.getJMSReplyTo();
        if (replyTo == null && (replyTo = this.resolveDefaultReplyDestination(session)) == null) {
            throw new InvalidDestinationException("Cannot determine reply destination: Request message does not contain reply-to destination, and no default reply destination set.");
        }
        return replyTo;
    }

    private Destination resolveDefaultReplyDestination(Session session) throws JMSException {
        if (this.defaultReplyDestination instanceof Destination) {
            return (Destination)this.defaultReplyDestination;
        }
        if (this.defaultReplyDestination instanceof DestinationNameHolder) {
            DestinationNameHolder nameHolder = (DestinationNameHolder)this.defaultReplyDestination;
            return this.destinationResolver.resolveDestinationName(session, nameHolder.name, nameHolder.isTopic);
        }
        return null;
    }

    private static class DestinationNameHolder {
        public final String name;
        public final boolean isTopic;

        public DestinationNameHolder(String name, boolean isTopic) {
            this.name = name;
            this.isTopic = isTopic;
        }
    }
}

