/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.MessageTimeoutException;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.jms.DefaultJmsHeaderMapper;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.jms.connection.ConnectionFactoryUtils;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.DynamicDestinationResolver;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsOutboundGateway
extends AbstractReplyProducingMessageHandler {
    private volatile Destination requestDestination;
    private volatile String requestDestinationName;
    private volatile Destination replyDestination;
    private volatile String replyDestinationName;
    private volatile DestinationResolver destinationResolver = new DynamicDestinationResolver();
    private volatile boolean pubSubDomain;
    private volatile long receiveTimeout = 5000L;
    private volatile int deliveryMode = 2;
    private volatile long timeToLive = 0L;
    private volatile int priority = 4;
    private volatile boolean explicitQosEnabled;
    private ConnectionFactory connectionFactory;
    private volatile MessageConverter messageConverter = new SimpleMessageConverter();
    private volatile JmsHeaderMapper headerMapper = new DefaultJmsHeaderMapper();
    private volatile boolean extractRequestPayload = true;
    private volatile boolean extractReplyPayload = true;
    private volatile boolean initialized;
    private final Object initializationMonitor = new Object();

    public String getComponentType() {
        return "jms:outbound-gateway";
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setRequestDestination(Destination requestDestination) {
        if (requestDestination instanceof Topic) {
            this.pubSubDomain = true;
        }
        this.requestDestination = requestDestination;
    }

    public void setRequestDestinationName(String requestDestinationName) {
        this.requestDestinationName = requestDestinationName;
    }

    public void setReplyDestination(Destination replyDestination) {
        this.replyDestination = replyDestination;
    }

    public void setReplyDestinationName(String replyDestinationName) {
        this.replyDestinationName = replyDestinationName;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    public void setPubSubDomain(boolean pubSubDomain) {
        this.pubSubDomain = pubSubDomain;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setExplicitQosEnabled(boolean explicitQosEnabled) {
        this.explicitQosEnabled = explicitQosEnabled;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"'messageConverter' must not be null");
        this.messageConverter = messageConverter;
    }

    public void setHeaderMapper(JmsHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    public void setExtractRequestPayload(boolean extractRequestPayload) {
        this.extractRequestPayload = extractRequestPayload;
    }

    public void setExtractReplyPayload(boolean extractReplyPayload) {
        this.extractReplyPayload = extractReplyPayload;
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.setOutputChannel(replyChannel);
    }

    private Destination getRequestDestination(Session session) throws JMSException {
        if (this.requestDestination != null) {
            return this.requestDestination;
        }
        Assert.notNull((Object)this.destinationResolver, (String)"DestinationResolver is required when relying upon the 'requestDestinationName' property.");
        return this.destinationResolver.resolveDestinationName(session, this.requestDestinationName, this.pubSubDomain);
    }

    private Destination getReplyDestination(Session session) throws JMSException {
        if (this.replyDestination != null) {
            return this.replyDestination;
        }
        if (this.replyDestinationName != null) {
            Assert.notNull((Object)this.destinationResolver, (String)"DestinationResolver is required when relying upon the 'replyDestinationName' property.");
            return this.destinationResolver.resolveDestinationName(session, this.replyDestinationName, this.pubSubDomain);
        }
        return session.createTemporaryQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onInit() {
        Object object = this.initializationMonitor;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            Assert.notNull((Object)this.connectionFactory, (String)"connectionFactory must not be null");
            Assert.isTrue((this.requestDestination != null || this.requestDestinationName != null ? 1 : 0) != 0, (String)"Either a 'requestDestination' or 'requestDestinationName' is required.");
            this.initialized = true;
        }
    }

    protected Object handleRequestMessage(Message<?> message) {
        if (!this.initialized) {
            this.afterPropertiesSet();
        }
        Message requestMessage = MessageBuilder.fromMessage(message).build();
        try {
            javax.jms.Message jmsReply = this.sendAndReceive(requestMessage);
            if (jmsReply == null) {
                throw new MessageTimeoutException(message, "failed to receive JMS response within timeout of: " + this.receiveTimeout + "ms");
            }
            Object result = jmsReply;
            if (this.extractReplyPayload) {
                result = this.messageConverter.fromMessage(jmsReply);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("converted JMS Message [" + jmsReply + "] to integration Message payload [" + result + "]"));
                }
            }
            return result;
        }
        catch (JMSException e) {
            throw new MessageHandlingException(requestMessage, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private javax.jms.Message sendAndReceive(Message<?> requestMessage) throws JMSException {
        javax.jms.Message message;
        Connection connection = this.createConnection();
        Session session = null;
        MessageProducer messageProducer = null;
        MessageConsumer messageConsumer = null;
        Destination replyTo = null;
        try {
            session = this.createSession(connection);
            Object objectToSend = requestMessage;
            if (this.extractRequestPayload) {
                objectToSend = requestMessage.getPayload();
            }
            javax.jms.Message jmsRequest = this.messageConverter.toMessage(objectToSend, session);
            this.headerMapper.fromHeaders(requestMessage.getHeaders(), jmsRequest);
            messageProducer = session.createProducer(this.getRequestDestination(session));
            replyTo = this.getReplyDestination(session);
            jmsRequest.setJMSReplyTo(replyTo);
            connection.start();
            if (this.explicitQosEnabled) {
                messageProducer.send(jmsRequest, this.deliveryMode, this.priority, this.timeToLive);
            } else {
                messageProducer.send(jmsRequest);
            }
            if (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic) {
                messageConsumer = session.createConsumer(replyTo);
            } else {
                String messageId = jmsRequest.getJMSMessageID().replaceAll("'", "''");
                String messageSelector = "JMSCorrelationID = '" + messageId + "'";
                messageConsumer = session.createConsumer(replyTo, messageSelector);
            }
            message = this.receiveTimeout >= 0L ? messageConsumer.receive(this.receiveTimeout) : messageConsumer.receive();
        }
        catch (Throwable throwable) {
            JmsUtils.closeMessageProducer(messageProducer);
            JmsUtils.closeMessageConsumer(messageConsumer);
            JmsUtils.closeSession((Session)session);
            this.deleteDestinationIfTemporary(replyTo);
            ConnectionFactoryUtils.releaseConnection((Connection)connection, (ConnectionFactory)this.connectionFactory, (boolean)true);
            throw throwable;
        }
        JmsUtils.closeMessageProducer((MessageProducer)messageProducer);
        JmsUtils.closeMessageConsumer((MessageConsumer)messageConsumer);
        JmsUtils.closeSession((Session)session);
        this.deleteDestinationIfTemporary(replyTo);
        ConnectionFactoryUtils.releaseConnection((Connection)connection, (ConnectionFactory)this.connectionFactory, (boolean)true);
        return message;
    }

    private void deleteDestinationIfTemporary(Destination destination) {
        try {
            if (destination instanceof TemporaryQueue) {
                ((TemporaryQueue)destination).delete();
            } else if (destination instanceof TemporaryTopic) {
                ((TemporaryTopic)destination).delete();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    protected Connection createConnection() throws JMSException {
        ConnectionFactory cf = this.connectionFactory;
        if (!this.pubSubDomain && cf instanceof QueueConnectionFactory) {
            return ((QueueConnectionFactory)cf).createQueueConnection();
        }
        return cf.createConnection();
    }

    protected Session createSession(Connection connection) throws JMSException {
        if (!this.pubSubDomain && connection instanceof QueueConnection) {
            return ((QueueConnection)connection).createQueueSession(false, 1);
        }
        return connection.createSession(false, 1);
    }
}

