/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import org.springframework.integration.Message;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.jms.DefaultJmsHeaderMapper;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessagePostProcessor;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsSendingMessageHandler
extends AbstractMessageHandler {
    private final JmsTemplate jmsTemplate;
    private volatile Destination destination;
    private volatile String destinationName;
    private volatile JmsHeaderMapper headerMapper = new DefaultJmsHeaderMapper();
    private volatile boolean extractPayload = true;

    public JmsSendingMessageHandler(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public void setDestination(Destination destination) {
        Assert.isNull((Object)this.destinationName, (String)"The 'destination' and 'destinationName' properties are mutually exclusive.");
        this.destination = destination;
    }

    public void setDestinationName(String destinationName) {
        Assert.isNull((Object)this.destination, (String)"The 'destination' and 'destinationName' properties are mutually exclusive.");
        this.destinationName = destinationName;
    }

    public void setHeaderMapper(JmsHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
    }

    public String getComponentType() {
        return "jms:outbound-channel-adapter";
    }

    protected void handleMessageInternal(Message<?> message) throws Exception {
        if (message == null) {
            throw new IllegalArgumentException("message must not be null");
        }
        Object objectToSend = this.extractPayload ? message.getPayload() : message;
        HeaderMappingMessagePostProcessor messagePostProcessor = new HeaderMappingMessagePostProcessor(message, this.headerMapper);
        if (this.destination != null) {
            this.jmsTemplate.convertAndSend(this.destination, objectToSend, (MessagePostProcessor)messagePostProcessor);
        } else if (this.destinationName != null) {
            this.jmsTemplate.convertAndSend(this.destinationName, objectToSend, (MessagePostProcessor)messagePostProcessor);
        } else {
            this.jmsTemplate.convertAndSend(objectToSend, (MessagePostProcessor)messagePostProcessor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HeaderMappingMessagePostProcessor
    implements MessagePostProcessor {
        private final Message<?> integrationMessage;
        private final JmsHeaderMapper headerMapper;

        private HeaderMappingMessagePostProcessor(Message<?> integrationMessage, JmsHeaderMapper headerMapper) {
            this.integrationMessage = integrationMessage;
            this.headerMapper = headerMapper;
        }

        public javax.jms.Message postProcessMessage(javax.jms.Message jmsMessage) throws JMSException {
            this.headerMapper.fromHeaders(this.integrationMessage.getHeaders(), jmsMessage);
            return jmsMessage;
        }
    }
}

