/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import java.util.Map;
import javax.jms.Destination;
import org.springframework.integration.Message;
import org.springframework.integration.MessagingException;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.jms.DefaultJmsHeaderMapper;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsDestinationPollingSource
extends IntegrationObjectSupport
implements MessageSource<Object> {
    private final JmsTemplate jmsTemplate;
    private volatile Destination destination;
    private volatile String destinationName;
    private volatile String messageSelector;
    private volatile JmsHeaderMapper headerMapper = new DefaultJmsHeaderMapper();

    public JmsDestinationPollingSource(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public void setDestination(Destination destination) {
        Assert.isNull((Object)this.destinationName, (String)"The 'destination' and 'destinationName' properties are mutually exclusive.");
        this.destination = destination;
    }

    public void setDestinationName(String destinationName) {
        Assert.isNull((Object)this.destination, (String)"The 'destination' and 'destinationName' properties are mutually exclusive.");
        this.destinationName = destinationName;
    }

    public String getComponentType() {
        return "jms:inbound-channel-adapter";
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public void setHeaderMapper(JmsHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    public Message<Object> receive() {
        Message convertedMessage = null;
        javax.jms.Message jmsMessage = this.doReceiveJmsMessage();
        if (jmsMessage == null) {
            return null;
        }
        try {
            Map mappedHeaders = this.headerMapper.toHeaders(jmsMessage);
            MessageConverter converter = this.jmsTemplate.getMessageConverter();
            Object convertedObject = converter.fromMessage(jmsMessage);
            MessageBuilder builder = convertedObject instanceof Message ? MessageBuilder.fromMessage((Message)((Message)convertedObject)) : MessageBuilder.withPayload((Object)convertedObject);
            convertedMessage = builder.copyHeadersIfAbsent(mappedHeaders).build();
        }
        catch (Exception e) {
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
        return convertedMessage;
    }

    private javax.jms.Message doReceiveJmsMessage() {
        javax.jms.Message jmsMessage = null;
        jmsMessage = this.destination != null ? this.jmsTemplate.receiveSelected(this.destination, this.messageSelector) : (this.destinationName != null ? this.jmsTemplate.receiveSelected(this.destinationName, this.messageSelector) : this.jmsTemplate.receiveSelected(this.messageSelector));
        return jmsMessage;
    }
}

