/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms.dsl;

import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.springframework.expression.Expression;
import org.springframework.integration.dsl.IntegrationComponentSpec;
import org.springframework.integration.dsl.MessageHandlerSpec;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.integration.jms.JmsOutboundGateway;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class JmsOutboundGatewaySpec
extends MessageHandlerSpec<JmsOutboundGatewaySpec, JmsOutboundGateway> {
    protected JmsOutboundGatewaySpec(ConnectionFactory connectionFactory) {
        this.target = new JmsOutboundGateway();
        ((JmsOutboundGateway)((Object)this.target)).setConnectionFactory(connectionFactory);
        ((JmsOutboundGateway)((Object)this.target)).setRequiresReply(true);
    }

    public JmsOutboundGatewaySpec extractRequestPayload(boolean extractPayload) {
        ((JmsOutboundGateway)((Object)this.target)).setExtractRequestPayload(extractPayload);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec extractReplyPayload(boolean extractPayload) {
        ((JmsOutboundGateway)((Object)this.target)).setExtractReplyPayload(extractPayload);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec headerMapper(JmsHeaderMapper headerMapper) {
        ((JmsOutboundGateway)((Object)this.target)).setHeaderMapper(headerMapper);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec requestDestination(Destination destination) {
        ((JmsOutboundGateway)((Object)this.target)).setRequestDestination(destination);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec requestDestination(String destination) {
        ((JmsOutboundGateway)((Object)this.target)).setRequestDestinationName(destination);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec requestDestinationExpression(String destination) {
        ((JmsOutboundGateway)((Object)this.target)).setRequestDestinationExpression(PARSER.parseExpression(destination));
        return (JmsOutboundGatewaySpec)this._this();
    }

    public <P> JmsOutboundGatewaySpec requestDestination(Function<Message<P>, ?> destinationFunction) {
        ((JmsOutboundGateway)((Object)this.target)).setRequestDestinationExpression((Expression)new FunctionExpression(destinationFunction));
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec replyDestination(Destination destination) {
        ((JmsOutboundGateway)((Object)this.target)).setReplyDestination(destination);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec replyDestination(String destination) {
        ((JmsOutboundGateway)((Object)this.target)).setReplyDestinationName(destination);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec replyDestinationExpression(String destination) {
        ((JmsOutboundGateway)((Object)this.target)).setReplyDestinationExpression(PARSER.parseExpression(destination));
        return (JmsOutboundGatewaySpec)this._this();
    }

    public <P> JmsOutboundGatewaySpec replyDestination(Function<Message<P>, ?> destinationFunction) {
        ((JmsOutboundGateway)((Object)this.target)).setReplyDestinationExpression((Expression)new FunctionExpression(destinationFunction));
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec destinationResolver(DestinationResolver destinationResolver) {
        ((JmsOutboundGateway)((Object)this.target)).setDestinationResolver(destinationResolver);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec jmsMessageConverter(MessageConverter messageConverter) {
        ((JmsOutboundGateway)((Object)this.target)).setMessageConverter(messageConverter);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec correlationKey(String correlationKey) {
        ((JmsOutboundGateway)((Object)this.target)).setCorrelationKey(correlationKey);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec requestPubSubDomain(boolean pubSubDomain) {
        ((JmsOutboundGateway)((Object)this.target)).setRequestPubSubDomain(pubSubDomain);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec replyPubSubDomain(boolean pubSubDomain) {
        ((JmsOutboundGateway)((Object)this.target)).setReplyPubSubDomain(pubSubDomain);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec deliveryPersistent(boolean deliveryPersistent) {
        ((JmsOutboundGateway)((Object)this.target)).setDeliveryPersistent(deliveryPersistent);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec priority(int priority) {
        ((JmsOutboundGateway)((Object)this.target)).setDefaultPriority(priority);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec timeToLive(long timeToLive) {
        ((JmsOutboundGateway)((Object)this.target)).setTimeToLive(timeToLive);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec receiveTimeout(long receiveTimeout) {
        ((JmsOutboundGateway)((Object)this.target)).setReceiveTimeout(receiveTimeout);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec explicitQosEnabled(boolean explicitQosEnabled) {
        ((JmsOutboundGateway)((Object)this.target)).setExplicitQosEnabled(explicitQosEnabled);
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec replyContainer() {
        ((JmsOutboundGateway)((Object)this.target)).setReplyContainerProperties(new JmsOutboundGateway.ReplyContainerProperties());
        return (JmsOutboundGatewaySpec)this._this();
    }

    public JmsOutboundGatewaySpec replyContainer(Consumer<ReplyContainerSpec> configurer) {
        Assert.notNull(configurer, (String)"'configurer' must not be null");
        ReplyContainerSpec spec = new ReplyContainerSpec();
        configurer.accept(spec);
        ((JmsOutboundGateway)((Object)this.target)).setReplyContainerProperties((JmsOutboundGateway.ReplyContainerProperties)spec.get());
        return (JmsOutboundGatewaySpec)this._this();
    }

    public class ReplyContainerSpec
    extends IntegrationComponentSpec<ReplyContainerSpec, JmsOutboundGateway.ReplyContainerProperties> {
        ReplyContainerSpec() {
            this.target = new JmsOutboundGateway.ReplyContainerProperties();
        }

        public ReplyContainerSpec sessionTransacted(Boolean sessionTransacted) {
            ((JmsOutboundGateway.ReplyContainerProperties)this.target).setSessionTransacted(sessionTransacted);
            return (ReplyContainerSpec)this._this();
        }

        public ReplyContainerSpec sessionAcknowledgeMode(Integer sessionAcknowledgeMode) {
            ((JmsOutboundGateway.ReplyContainerProperties)this.target).setSessionAcknowledgeMode(sessionAcknowledgeMode);
            return (ReplyContainerSpec)this._this();
        }

        public ReplyContainerSpec receiveTimeout(Long receiveTimeout) {
            ((JmsOutboundGateway.ReplyContainerProperties)this.target).setReceiveTimeout(receiveTimeout);
            return (ReplyContainerSpec)this._this();
        }

        public ReplyContainerSpec recoveryInterval(Long recoveryInterval) {
            ((JmsOutboundGateway.ReplyContainerProperties)this.target).setRecoveryInterval(recoveryInterval);
            return (ReplyContainerSpec)this._this();
        }

        public ReplyContainerSpec cacheLevel(Integer cacheLevel) {
            ((JmsOutboundGateway.ReplyContainerProperties)this.target).setCacheLevel(cacheLevel);
            return (ReplyContainerSpec)this._this();
        }

        public ReplyContainerSpec concurrentConsumers(Integer concurrentConsumers) {
            ((JmsOutboundGateway.ReplyContainerProperties)this.target).setConcurrentConsumers(concurrentConsumers);
            return (ReplyContainerSpec)this._this();
        }

        public ReplyContainerSpec maxConcurrentConsumers(Integer maxConcurrentConsumers) {
            ((JmsOutboundGateway.ReplyContainerProperties)this.target).setMaxConcurrentConsumers(maxConcurrentConsumers);
            return (ReplyContainerSpec)this._this();
        }

        public ReplyContainerSpec maxMessagesPerTask(Integer maxMessagesPerTask) {
            ((JmsOutboundGateway.ReplyContainerProperties)this.target).setMaxMessagesPerTask(maxMessagesPerTask);
            return (ReplyContainerSpec)this._this();
        }

        public ReplyContainerSpec idleConsumerLimit(Integer idleConsumerLimit) {
            ((JmsOutboundGateway.ReplyContainerProperties)this.target).setIdleConsumerLimit(idleConsumerLimit);
            return (ReplyContainerSpec)this._this();
        }

        public ReplyContainerSpec idleTaskExecutionLimit(Integer idleTaskExecutionLimit) {
            ((JmsOutboundGateway.ReplyContainerProperties)this.target).setIdleTaskExecutionLimit(idleTaskExecutionLimit);
            return (ReplyContainerSpec)this._this();
        }

        public ReplyContainerSpec taskExecutor(Executor taskExecutor) {
            ((JmsOutboundGateway.ReplyContainerProperties)this.target).setTaskExecutor(taskExecutor);
            return (ReplyContainerSpec)this._this();
        }

        public ReplyContainerSpec idleReplyContainerTimeout(long idleReplyContainerTimeout) {
            ((JmsOutboundGateway)((Object)JmsOutboundGatewaySpec.this.target)).setIdleReplyContainerTimeout(idleReplyContainerTimeout);
            return this;
        }
    }
}

