/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import java.util.Map;
import javax.jms.Destination;
import org.springframework.integration.endpoint.AbstractMessageSource;
import org.springframework.integration.jms.DefaultJmsHeaderMapper;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.integration.jms.util.JmsAdapterUtils;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public class JmsDestinationPollingSource
extends AbstractMessageSource<Object> {
    private final JmsTemplate jmsTemplate;
    private volatile Destination destination;
    private volatile String destinationName;
    private volatile String messageSelector;
    private volatile JmsHeaderMapper headerMapper = new DefaultJmsHeaderMapper();
    private volatile String sessionAcknowledgeMode;
    private volatile boolean extractPayload = true;

    public JmsDestinationPollingSource(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public void setDestination(Destination destination) {
        Assert.isNull((Object)this.destinationName, (String)"The 'destination' and 'destinationName' properties are mutually exclusive.");
        this.destination = destination;
    }

    public void setDestinationName(String destinationName) {
        Assert.isNull((Object)this.destination, (String)"The 'destination' and 'destinationName' properties are mutually exclusive.");
        this.destinationName = destinationName;
    }

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
    }

    public String getComponentType() {
        return "jms:inbound-channel-adapter";
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public void setHeaderMapper(JmsHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    public void setSessionAcknowledgeMode(String sessionAcknowledgeMode) {
        this.sessionAcknowledgeMode = sessionAcknowledgeMode;
    }

    protected void onInit() {
        Integer acknowledgeMode;
        if (this.sessionAcknowledgeMode != null && (acknowledgeMode = JmsAdapterUtils.parseAcknowledgeMode(this.sessionAcknowledgeMode)) != null) {
            if (0 == acknowledgeMode) {
                this.jmsTemplate.setSessionTransacted(true);
            } else {
                this.jmsTemplate.setSessionAcknowledgeMode(acknowledgeMode.intValue());
            }
        }
    }

    protected Object doReceive() {
        javax.jms.Message jmsMessage = this.doReceiveJmsMessage();
        if (jmsMessage == null) {
            return null;
        }
        try {
            MessageConverter converter;
            Map mappedHeaders = this.headerMapper.toHeaders(jmsMessage);
            Object object = jmsMessage;
            if (this.extractPayload && (converter = this.jmsTemplate.getMessageConverter()) != null) {
                object = converter.fromMessage(jmsMessage);
            }
            AbstractIntegrationMessageBuilder builder = object instanceof Message ? this.getMessageBuilderFactory().fromMessage((Message)object) : this.getMessageBuilderFactory().withPayload(object);
            return builder.copyHeadersIfAbsent(mappedHeaders);
        }
        catch (Exception e) {
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    private javax.jms.Message doReceiveJmsMessage() {
        javax.jms.Message jmsMessage = null;
        jmsMessage = this.destination != null ? this.jmsTemplate.receiveSelected(this.destination, this.messageSelector) : (this.destinationName != null ? this.jmsTemplate.receiveSelected(this.destinationName, this.messageSelector) : this.jmsTemplate.receiveSelected(this.messageSelector));
        return jmsMessage;
    }
}

