/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.monitor;

import java.util.concurrent.atomic.AtomicInteger;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.monitor.ExponentialMovingAverage;
import org.springframework.integration.monitor.ExponentialMovingAverageRate;
import org.springframework.integration.monitor.ExponentialMovingAverageRatio;
import org.springframework.integration.monitor.MessageChannelMetrics;
import org.springframework.integration.monitor.Statistics;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.util.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource
public class DirectChannelMetrics
implements MethodInterceptor,
MessageChannelMetrics {
    protected final Log logger = LogFactory.getLog(this.getClass());
    public static final long ONE_SECOND_SECONDS = 1L;
    public static final long ONE_MINUTE_SECONDS = 60L;
    public static final int DEFAULT_MOVING_AVERAGE_WINDOW = 10;
    private ExponentialMovingAverage sendDuration = new ExponentialMovingAverage(10);
    private final ExponentialMovingAverageRate sendErrorRate = new ExponentialMovingAverageRate(1.0, 60.0, 10);
    private final ExponentialMovingAverageRatio sendSuccessRatio = new ExponentialMovingAverageRatio(60.0, 10);
    private final ExponentialMovingAverageRate sendRate = new ExponentialMovingAverageRate(1.0, 60.0, 10);
    private final AtomicInteger sendCount = new AtomicInteger();
    private final AtomicInteger sendErrorCount = new AtomicInteger();
    private final String name;

    public DirectChannelMetrics(String name) {
        this.name = name;
    }

    public void destroy() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.sendDuration);
        }
    }

    public String getName() {
        return this.name;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String method = invocation.getMethod().getName();
        MessageChannel channel = (MessageChannel)invocation.getThis();
        return this.doInvoke(invocation, method, channel);
    }

    protected Object doInvoke(MethodInvocation invocation, String method, MessageChannel channel) throws Throwable {
        if ("send".equals(method)) {
            Message message = (Message)invocation.getArguments()[0];
            return this.monitorSend(invocation, channel, message);
        }
        return invocation.proceed();
    }

    private Object monitorSend(MethodInvocation invocation, MessageChannel channel, Message<?> message) throws Throwable {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Recording send on channel(" + channel + ") : message(" + message + ")"));
        }
        StopWatch timer = new StopWatch(channel + ".send:execution");
        try {
            timer.start();
            this.sendCount.incrementAndGet();
            this.sendRate.increment();
            Object result = invocation.proceed();
            timer.stop();
            if (((Boolean)result).booleanValue()) {
                this.sendSuccessRatio.success();
                this.sendDuration.append(timer.getTotalTimeMillis());
            } else {
                this.sendSuccessRatio.failure();
                this.sendErrorCount.incrementAndGet();
                this.sendErrorRate.increment();
            }
            Object object = result;
            return object;
        }
        catch (Throwable e) {
            this.sendSuccessRatio.failure();
            this.sendErrorCount.incrementAndGet();
            this.sendErrorRate.increment();
            throw e;
        }
        finally {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)timer);
            }
        }
    }

    @Override
    public synchronized void reset() {
        this.sendDuration.reset();
        this.sendErrorRate.reset();
        this.sendSuccessRatio.reset();
        this.sendRate.reset();
        this.sendCount.set(0);
        this.sendErrorCount.set(0);
    }

    @Override
    public int getSendCount() {
        return this.sendCount.get();
    }

    @Override
    public int getSendErrorCount() {
        return this.sendErrorCount.get();
    }

    @Override
    public double getTimeSinceLastSend() {
        return this.sendRate.getTimeSinceLastMeasurement();
    }

    @Override
    public double getMeanSendRate() {
        return this.sendRate.getMean();
    }

    @Override
    public double getMeanErrorRate() {
        return this.sendErrorRate.getMean();
    }

    @Override
    public double getMeanErrorRatio() {
        return 1.0 - this.sendSuccessRatio.getMean();
    }

    @Override
    public double getMeanSendDuration() {
        return this.sendDuration.getMean();
    }

    @Override
    public double getMinSendDuration() {
        return this.sendDuration.getMin();
    }

    @Override
    public double getMaxSendDuration() {
        return this.sendDuration.getMax();
    }

    @Override
    public double getStandardDeviationSendDuration() {
        return this.sendDuration.getStandardDeviation();
    }

    @Override
    public Statistics getSendDuration() {
        return this.sendDuration.getStatistics();
    }

    @Override
    public Statistics getSendRate() {
        return this.sendRate.getStatistics();
    }

    @Override
    public Statistics getErrorRate() {
        return this.sendErrorRate.getStatistics();
    }

    public String toString() {
        return String.format("MessageChannelMonitor: [name=%s, sends=%d]", this.name, this.sendCount.get());
    }
}

