/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.monitor;

import org.springframework.integration.monitor.ExponentialMovingAverage;
import org.springframework.integration.monitor.Statistics;

public class ExponentialMovingAverageRatio {
    private volatile double weight;
    private volatile double sum;
    private volatile long t0 = System.currentTimeMillis();
    private final double lapse;
    private final ExponentialMovingAverage cumulative;

    public ExponentialMovingAverageRatio(double lapsePeriod, int window) {
        this.cumulative = new ExponentialMovingAverage(window);
        this.lapse = lapsePeriod > 0.0 ? 0.001 / lapsePeriod : 0.0;
    }

    public void success() {
        this.append(1);
    }

    public void failure() {
        this.append(0);
    }

    public synchronized void reset() {
        this.weight = 0.0;
        this.sum = 0.0;
        this.t0 = System.currentTimeMillis();
        this.cumulative.reset();
    }

    private synchronized void append(int value) {
        long t = System.currentTimeMillis();
        double alpha = Math.exp((double)(this.t0 - t) * this.lapse);
        this.t0 = t;
        this.sum = alpha * this.sum + (double)value;
        this.weight = alpha * this.weight + 1.0;
        this.cumulative.append(this.sum / this.weight);
    }

    public int getCount() {
        return this.cumulative.getCount();
    }

    public long getCountLong() {
        return this.cumulative.getCountLong();
    }

    public double getTimeSinceLastMeasurement() {
        return (double)(System.currentTimeMillis() - this.t0) / 1000.0;
    }

    public double getMean() {
        long count = this.cumulative.getCountLong();
        if (count == 0L) {
            return 1.0;
        }
        long t = System.currentTimeMillis();
        double alpha = Math.exp((double)(this.t0 - t) * this.lapse);
        return alpha * this.cumulative.getMean() + 1.0 - alpha;
    }

    public double getStandardDeviation() {
        return this.cumulative.getStandardDeviation();
    }

    public double getMax() {
        return this.cumulative.getMax();
    }

    public double getMin() {
        return this.cumulative.getMin();
    }

    public Statistics getStatistics() {
        return new Statistics(this.getCount(), this.getMin(), this.getMax(), this.getMean(), this.getStandardDeviation());
    }

    public String toString() {
        return String.format("[%s, timeSinceLast=%f]", this.getStatistics(), this.getTimeSinceLastMeasurement());
    }
}

