/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jmx.inbound;

import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.endpoint.AbstractMessageSource;
import org.springframework.jmx.support.ObjectNameManager;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public class AttributePollingMessageSource
extends AbstractMessageSource<Object> {
    private ObjectName objectName;
    private String attributeName;
    private MBeanServerConnection server;

    public void setServer(MBeanServerConnection server) {
        this.server = server;
    }

    public void setObjectName(String objectName) {
        try {
            this.objectName = ObjectNameManager.getInstance((String)objectName);
        }
        catch (MalformedObjectNameException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getComponentType() {
        return "jmx:attribute-polling-channel-adapter";
    }

    protected void onInit() {
        super.onInit();
        Assert.notNull((Object)this.server, (String)"MBeanServer is required");
        Assert.notNull((Object)this.objectName, (String)"object name is required");
        Assert.notNull((Object)this.attributeName, (String)"attribute name is required");
    }

    protected @Nullable Object doReceive() {
        try {
            return this.server.getAttribute(this.objectName, this.attributeName);
        }
        catch (Exception ex) {
            throw new MessagingException("failed to retrieve JMX attribute '" + this.attributeName + "' on MBean [" + String.valueOf(this.objectName) + "]", (Throwable)ex);
        }
    }
}

