/*
 * Copyright 2013-present the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.integration.jmx.inbound;

import javax.management.ObjectName;

/**
 * The strategy to filter out MBean attributes before retrieval of their values.
 *
 * @author Stuart Williams
 * @author Artem Bilan
 *
 * @since 7.0
 */
@FunctionalInterface
public interface MBeanAttributeFilter {

	/**
	 * @param objectName The object name.
	 * @param attributeName The attribute name.
	 * @return true if the attribute passes the filter.
	 */
	boolean accept(ObjectName objectName, String attributeName);

}
