/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.outbound;

import java.util.Map;
import org.springframework.integration.Message;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.jpa.core.JpaExecutor;
import org.springframework.integration.jpa.support.OutboundGatewayType;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaOutboundGateway
extends AbstractReplyProducingMessageHandler {
    private final JpaExecutor jpaExecutor;
    private OutboundGatewayType gatewayType = OutboundGatewayType.UPDATING;
    private boolean producesReply = true;

    public JpaOutboundGateway(JpaExecutor jpaExecutor) {
        Assert.notNull((Object)jpaExecutor, (String)"jpaExecutor must not be null.");
        this.jpaExecutor = jpaExecutor;
    }

    protected void onInit() {
        super.onInit();
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        Object result;
        if (OutboundGatewayType.RETRIEVING.equals((Object)this.gatewayType)) {
            result = this.jpaExecutor.poll(requestMessage);
        } else if (OutboundGatewayType.UPDATING.equals((Object)this.gatewayType)) {
            result = this.jpaExecutor.executeOutboundJpaOperation(requestMessage);
        } else {
            throw new IllegalArgumentException(String.format("GatewayType  '%s' is not supported.", new Object[]{this.gatewayType}));
        }
        if (result == null || !this.producesReply) {
            return null;
        }
        return MessageBuilder.withPayload((Object)result).copyHeaders((Map)requestMessage.getHeaders()).build();
    }

    public void setGatewayType(OutboundGatewayType gatewayType) {
        Assert.notNull((Object)((Object)gatewayType), (String)"gatewayType must not be null.");
        this.gatewayType = gatewayType;
    }

    public void setProducesReply(boolean producesReply) {
        this.producesReply = producesReply;
    }
}

